/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.serviceendpoint;

import io.grpc.ServerBuilder;
import io.netty.handler.ssl.SslContext;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.GrpcServicesBuilder;
import org.ballerinalang.net.grpc.config.EndpointConfiguration;
import org.ballerinalang.net.grpc.nativeimpl.EndpointUtils;
import org.ballerinalang.net.grpc.ssl.SSLHandlerFactory;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructInfo;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="initEndpoint", receiver=@Receiver(type=TypeKind.STRUCT, structType="Service", structPackage="ballerina.grpc"), args={@Argument(name="config", type=TypeKind.STRUCT, structType="ServiceEndpointConfiguration", structPackage="ballerina.grpc")}, isPublic=true)
public class InitEndpoint
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        try {
            ServerBuilder serverBuilder;
            Struct serviceEndpoint = BLangConnectorSPIUtil.getConnectorEndpointStruct((Context)context);
            Struct serviceEndpointConfig = serviceEndpoint.getStructField("config");
            EndpointConfiguration configuration = EndpointUtils.getEndpointConfiguration(serviceEndpointConfig);
            if (configuration.getSslConfig() != null) {
                SslContext sslCtx = new SSLHandlerFactory(configuration.getSslConfig()).createHttp2TLSContextForServer();
                serverBuilder = GrpcServicesBuilder.initService(configuration, sslCtx);
            } else {
                serverBuilder = GrpcServicesBuilder.initService(configuration, null);
            }
            serviceEndpoint.addNativeData("SERVICE_BUILDER", (Object)serverBuilder);
            context.setReturnValues(new BValue[0]);
        }
        catch (Throwable throwable) {
            BStruct err = InitEndpoint.getConnectorError(context, throwable);
            context.setError(err);
        }
    }

    private static BStruct getConnectorError(Context context, Throwable throwable) {
        PackageInfo grpcPackageInfo = context.getProgramFile().getPackageInfo("grpc");
        StructInfo errorStructInfo = grpcPackageInfo.getStructInfo("ConnectorError");
        BStruct grpcConnectorError = new BStruct(errorStructInfo.getType());
        if (throwable.getMessage() == null) {
            grpcConnectorError.setStringField(0, "Service Initialization error.");
        } else {
            grpcConnectorError.setStringField(0, throwable.getMessage());
        }
        return grpcConnectorError;
    }
}

