/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto;

import java.util.List;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.net.grpc.config.ServiceConfiguration;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.proto.ServiceProtoUtils;
import org.ballerinalang.net.grpc.proto.definition.File;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;

@SupportedAnnotationPackages(value={"ballerina.grpc"})
public class ServiceProtoBuilder
extends AbstractCompilerPlugin {
    private DiagnosticLog dlog;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        for (AnnotationAttachmentNode annotationNode : annotations) {
            if (!"messageListener".equals(annotationNode.getAnnotationName().getValue())) continue;
            return;
        }
        try {
            File fileDefinition = ServiceProtoUtils.generateProtoDefinition(serviceNode);
            ServiceConfiguration serviceConfig = ServiceProtoUtils.getServiceConfiguration(serviceNode);
            ServiceProtoUtils.writeServiceFiles(fileDefinition, serviceNode.getName().getValue(), serviceConfig.isGenerateClientConnector());
        }
        catch (GrpcServerException e) {
            this.dlog.logDiagnostic(Diagnostic.Kind.WARNING, serviceNode.getPosition(), (CharSequence)e.getMessage());
        }
    }
}

