/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto.definition;

import com.google.protobuf.DescriptorProtos;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.net.grpc.proto.ServiceProtoConstants;

public class Field {
    private DescriptorProtos.FieldDescriptorProto fieldDescriptorProto;
    private String fieldType;
    private String fieldLabel;
    private static final Map<String, DescriptorProtos.FieldDescriptorProto.Type> STRING_TYPE_MAP = new HashMap<String, DescriptorProtos.FieldDescriptorProto.Type>();
    private static final Map<String, DescriptorProtos.FieldDescriptorProto.Label> STRING_LABEL_MAP;
    private static final Map<String, String> BALLERINA_TO_PROTO_MAP;

    private Field(DescriptorProtos.FieldDescriptorProto descriptorProto) {
        this.fieldDescriptorProto = descriptorProto;
    }

    public static Builder newBuilder(String fieldName) {
        return new Builder(fieldName);
    }

    public DescriptorProtos.FieldDescriptorProto getFieldDescriptorProto() {
        return this.fieldDescriptorProto;
    }

    public String getFieldDefinition() {
        StringBuilder fieldDefinition = new StringBuilder();
        if (this.fieldLabel != null) {
            fieldDefinition.append(this.fieldLabel).append(" ");
        }
        fieldDefinition.append(this.fieldType).append(" ").append(this.fieldDescriptorProto.getName()).append(" = ").append(this.fieldDescriptorProto.getNumber()).append(";").append(ServiceProtoConstants.NEW_LINE_CHARACTER);
        return fieldDefinition.toString();
    }

    static {
        STRING_TYPE_MAP.put("double", DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE);
        STRING_TYPE_MAP.put("float", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT);
        STRING_TYPE_MAP.put("int32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32);
        STRING_TYPE_MAP.put("int64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64);
        STRING_TYPE_MAP.put("uint32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32);
        STRING_TYPE_MAP.put("uint64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64);
        STRING_TYPE_MAP.put("sint32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32);
        STRING_TYPE_MAP.put("sint64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64);
        STRING_TYPE_MAP.put("fixed32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32);
        STRING_TYPE_MAP.put("fixed64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64);
        STRING_TYPE_MAP.put("sfixed32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32);
        STRING_TYPE_MAP.put("sfixed64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64);
        STRING_TYPE_MAP.put("bool", DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL);
        STRING_TYPE_MAP.put("string", DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        STRING_TYPE_MAP.put("bytes", DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES);
        STRING_TYPE_MAP.put("int", DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64);
        STRING_TYPE_MAP.put("boolean", DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL);
        STRING_TYPE_MAP.put("blob", DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES);
        STRING_LABEL_MAP = new HashMap<String, DescriptorProtos.FieldDescriptorProto.Label>();
        STRING_LABEL_MAP.put("optional", DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
        STRING_LABEL_MAP.put("required", DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
        STRING_LABEL_MAP.put("repeated", DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED);
        BALLERINA_TO_PROTO_MAP = new HashMap<String, String>();
        BALLERINA_TO_PROTO_MAP.put("int", "int64");
        BALLERINA_TO_PROTO_MAP.put("boolean", "bool");
        BALLERINA_TO_PROTO_MAP.put("string", "string");
        BALLERINA_TO_PROTO_MAP.put("blob", "byte");
    }

    public static class Builder {
        private DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
        private String fieldType;
        private String fieldLabel;

        public Field build() {
            Field field = new Field(this.fieldDescriptorBuilder.build());
            field.fieldType = this.fieldType;
            field.fieldLabel = this.fieldLabel;
            return field;
        }

        private Builder(String fieldName) {
            this.fieldDescriptorBuilder.setName(fieldName);
        }

        public Builder setLabel(String label) {
            if (label == null) {
                return this;
            }
            this.fieldLabel = label;
            DescriptorProtos.FieldDescriptorProto.Label protoLabel = (DescriptorProtos.FieldDescriptorProto.Label)STRING_LABEL_MAP.get(label);
            if (protoLabel == null) {
                throw new IllegalArgumentException("Illegal label: " + label);
            }
            this.fieldDescriptorBuilder.setLabel(protoLabel);
            return this;
        }

        public Builder setType(String type) {
            this.fieldType = BALLERINA_TO_PROTO_MAP.get(type) != null ? (String)BALLERINA_TO_PROTO_MAP.get(type) : type;
            DescriptorProtos.FieldDescriptorProto.Type primType = (DescriptorProtos.FieldDescriptorProto.Type)STRING_TYPE_MAP.get(this.fieldType);
            if (primType != null) {
                this.fieldDescriptorBuilder.setType(primType);
            } else {
                this.fieldDescriptorBuilder.setTypeName(this.fieldType);
            }
            return this;
        }

        public Builder setIndex(int index) {
            this.fieldDescriptorBuilder.setNumber(index);
            return this;
        }

        public Builder setDefaultValue(String defaultValue) {
            if (defaultValue != null) {
                this.fieldDescriptorBuilder.setDefaultValue(defaultValue);
            }
            return this;
        }
    }
}

