/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.ssl;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SSLConfig.class);
    private static final String separator = ",";
    private File keyStore;
    private String keyStorePass;
    private String certPass;
    private File trustStore;
    private String trustStorePass;
    private String sslProtocol;
    private String tlsStoreType;
    private String sslVerifyClient;
    private String[] cipherSuites;
    private int cacheSize;
    private int cacheValidityPeriod;
    private String[] enableProtocols;
    private boolean validateCertificateEnabled;
    private boolean enableSessionCreation;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] serverNames;
    private String[] sniMatchers;

    public SSLConfig() {
    }

    public String getSslVerifyClient() {
        return this.sslVerifyClient;
    }

    public void setSslVerifyClient(String sslVerifyClient) {
        this.sslVerifyClient = sslVerifyClient;
    }

    public boolean isValidateCertificateEnabled() {
        return this.validateCertificateEnabled;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public void setValidateCertificateEnabled(boolean validateCertificateEnabled) {
        this.validateCertificateEnabled = validateCertificateEnabled;
    }

    public SSLConfig(File keyStore, String keyStorePass) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using key store" + keyStore);
        }
        this.keyStore = keyStore;
        this.keyStorePass = keyStorePass;
    }

    public void setKeyStore(File keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public SSLConfig setCertPass(String certPass) {
        this.certPass = certPass;
        return this;
    }

    public File getTrustStore() {
        return this.trustStore;
    }

    public SSLConfig setTrustStore(File trustStore) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using trust store" + trustStore);
        }
        this.trustStore = trustStore;
        return this;
    }

    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    public SSLConfig setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
        return this;
    }

    public File getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public String[] getSniMatchers() {
        return this.sniMatchers == null ? null : (String[])this.sniMatchers.clone();
    }

    public void setSniMatchers(String sniMatchers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using sniMatchers" + sniMatchers);
        }
        this.sniMatchers = sniMatchers.split(separator);
    }

    public String[] getServerNames() {
        return this.serverNames == null ? null : (String[])this.serverNames.clone();
    }

    public void setServerNames(String serverNames) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using serverNames" + serverNames);
        }
        this.serverNames = serverNames.replaceAll("\\s+", "").split(separator);
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set WantClientAuth" + wantClientAuth);
        }
        this.wantClientAuth = wantClientAuth;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set NeedClientAuth" + needClientAuth);
        }
        this.needClientAuth = needClientAuth;
    }

    public void setSSLProtocol(String sslProtocol) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set SSLProtocol" + sslProtocol);
        }
        this.sslProtocol = sslProtocol;
    }

    public String getSSLProtocol() {
        return this.sslProtocol;
    }

    public String getTLSStoreType() {
        return this.tlsStoreType;
    }

    public void setTLSStoreType(String tlsStoreType) {
        this.tlsStoreType = tlsStoreType;
    }

    public boolean isEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public void setEnableSessionCreation(boolean enableSessionCreation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enable Session Creation" + enableSessionCreation);
        }
        this.enableSessionCreation = enableSessionCreation;
    }

    public String[] getEnableProtocols() {
        return this.enableProtocols == null ? null : (String[])this.enableProtocols.clone();
    }

    public void setEnableProtocols(String enableProtocols) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set enable protocols" + enableProtocols);
        }
        this.enableProtocols = enableProtocols.replaceAll("\\s+", "").split(separator);
    }

    public String[] getCipherSuites() {
        return this.cipherSuites == null ? null : (String[])this.cipherSuites.clone();
    }

    public void setCipherSuites(String cipherSuites) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set supported cipherSuites" + cipherSuites);
        }
        this.cipherSuites = cipherSuites.replaceAll("\\s+", "").split(separator);
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheValidityPeriod() {
        return this.cacheValidityPeriod;
    }

    public void setCacheValidityPeriod(int cacheValidityPeriod) {
        this.cacheValidityPeriod = cacheValidityPeriod;
    }
}

