/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.ssl;

import io.grpc.netty.GrpcSslContexts;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.ballerinalang.net.grpc.exception.GrpcSSLValidationException;
import org.ballerinalang.net.grpc.ssl.SSLConfig;
import org.ballerinalang.net.grpc.ssl.SSLHandlerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SSLHandlerFactory.class);
    private static final String SSL_SERVER_KEY_FILE = "grpcSslServer.key";
    private static final String SSL_SERVER_CERT_FILE = "grpcSslServer.pem";
    private SSLConfig sslConfig;
    private KeyManagerFactory kmf;
    private TrustManagerFactory tmf;

    public SSLHandlerFactory(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        String protocol = sslConfig.getSSLProtocol();
        try {
            KeyManager[] keyManagers = null;
            if (sslConfig.getKeyStore() != null) {
                KeyStore ks = this.getKeyStore(sslConfig.getKeyStore(), sslConfig.getKeyStorePass());
                this.kmf = KeyManagerFactory.getInstance(algorithm);
                if (ks != null) {
                    this.kmf.init(ks, sslConfig.getCertPass() != null ? sslConfig.getCertPass().toCharArray() : sslConfig.getKeyStorePass().toCharArray());
                    keyManagers = this.kmf.getKeyManagers();
                }
            }
            TrustManager[] trustManagers = null;
            if (sslConfig.getTrustStore() != null && sslConfig.getTrustStore().isFile()) {
                KeyStore tks = this.getKeyStore(sslConfig.getTrustStore(), sslConfig.getTrustStorePass());
                this.tmf = TrustManagerFactory.getInstance(algorithm);
                this.tmf.init(tks);
                trustManagers = this.tmf.getTrustManagers();
            }
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(keyManagers, trustManagers, null);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException("Failed to initialize the SSLContext", e);
        }
    }

    private KeyStore getKeyStore(File trustStore, String trustStorePassword) throws IOException {
        KeyStore ks = null;
        String tlsStoreType = this.sslConfig.getTLSStoreType();
        if (trustStore != null && trustStore.isFile() && trustStorePassword != null && !trustStorePassword.isEmpty()) {
            try (FileInputStream is = new FileInputStream(trustStore);){
                ks = KeyStore.getInstance(tlsStoreType);
                ks.load(is, trustStorePassword.toCharArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        return ks;
    }

    public SslContext createHttp2TLSContextForServer() {
        SslContext grpcSslContexts;
        KeyStore keyStore;
        List<String> ciphers = this.sslConfig.getCipherSuites() != null && this.sslConfig.getCipherSuites().length > 0 ? Arrays.asList(this.sslConfig.getCipherSuites()) : SSLHandlerUtils.preferredTestCiphers();
        SslProvider provider = SslProvider.OPENSSL;
        File keyFile = new File(SSL_SERVER_KEY_FILE);
        File certFile = new File(SSL_SERVER_CERT_FILE);
        try {
            if (keyFile.createNewFile() && certFile.createNewFile()) {
                LOG.debug("Successfully created meta cert and key files. ");
            }
            keyStore = this.getKeyStore(this.sslConfig.getKeyStore(), this.sslConfig.getKeyStorePass());
        }
        catch (IOException e) {
            throw new GrpcSSLValidationException("Error generating intermediate cert temporary files.", e);
        }
        try {
            SSLHandlerUtils.writeFile(keyStore, this.sslConfig.getKeyStorePass());
        }
        catch (KeyStoreException e) {
            throw new GrpcSSLValidationException("Error writing intermediate cert temporary files.", e);
        }
        try {
            grpcSslContexts = GrpcSslContexts.forServer((File)certFile, (File)keyFile).keyManager(this.kmf).sslProvider(provider).ciphers(ciphers, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).clientAuth(ClientAuth.NONE).build();
        }
        catch (SSLException e) {
            throw new GrpcSSLValidationException("Error generating SSL context.", e);
        }
        if (keyFile.delete() && certFile.delete()) {
            LOG.debug("Successfully deleted meta cert and key files. ");
        }
        return grpcSslContexts;
    }

    public SslContext createHttp2TLSContextForClient() throws SSLException {
        SslProvider provider = SslProvider.OPENSSL;
        List<String> ciphers = this.sslConfig.getCipherSuites() != null && this.sslConfig.getCipherSuites().length > 0 ? Arrays.asList(this.sslConfig.getCipherSuites()) : SSLHandlerUtils.preferredTestCiphers();
        return GrpcSslContexts.forClient().sslProvider(provider).trustManager(this.tmf).protocols(this.sslConfig.getEnableProtocols()).ciphers(ciphers, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build();
    }
}

