/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.ssl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.ballerinalang.net.grpc.exception.GrpcSSLValidationException;

public class SSLHandlerUtils {
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT = "-----END CERTIFICATE-----";
    private static final String BEGIN_KEY = "-----BEGIN PRIVATE KEY-----";
    private static final String END_KEY = "-----END PRIVATE KEY-----";
    private static final String SSL_SERVER_KEY_FILE = "grpcSslServer.key";
    private static final String SSL_SERVER_CERT_FILE = "grpcSslServer.pem";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    static void writeFile(KeyStore keyStore, String keyStorePass) throws KeyStoreException {
        List<Certificate> userCertificate = SSLHandlerUtils.getCertificates(keyStore);
        try (BufferedWriter writer2 = Files.newBufferedWriter(Paths.get(SSL_SERVER_KEY_FILE, new String[0]), new OpenOption[0]);
             BufferedWriter writer = Files.newBufferedWriter(Paths.get(SSL_SERVER_CERT_FILE, new String[0]), new OpenOption[0]);){
            writer.write(SSLHandlerUtils.formatCrtFileContents(userCertificate));
            writer2.write(SSLHandlerUtils.formatKeyFileContents(keyStore.getKey(keyStorePass, keyStorePass.toCharArray()).getEncoded()));
        }
        catch (IOException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new GrpcSSLValidationException("Error writing cert files.", e);
        }
    }

    private static List<Certificate> getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        for (String alias : Collections.list(keyStore.aliases())) {
            Certificate[] certificateChain = keyStore.getCertificateChain(alias);
            if (certificateChain != null) {
                certs.addAll(Arrays.asList(certificateChain));
            }
            certs.add(keyStore.getCertificate(alias));
        }
        return certs;
    }

    private static String formatCrtFileContents(List<Certificate> rawCrtText) {
        Base64.Encoder encoder;
        StringBuilder encodedCerts = new StringBuilder();
        try {
            encoder = Base64.getMimeEncoder(64, LINE_SEPARATOR.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new GrpcSSLValidationException("Invalid Charset Getting Encoder.", e);
        }
        for (Certificate certificate : rawCrtText) {
            try {
                encodedCerts.append(new String(encoder.encode(certificate.getEncoded()), "UTF-8")).append(LINE_SEPARATOR);
            }
            catch (CertificateEncodingException e) {
                throw new GrpcSSLValidationException("Error getting cert chain.", e);
            }
            catch (UnsupportedEncodingException e) {
                throw new GrpcSSLValidationException("Invalid Charset Name at Cert generation.", e);
            }
        }
        return BEGIN_CERT + LINE_SEPARATOR + encodedCerts.toString() + LINE_SEPARATOR + END_CERT;
    }

    public static List<String> preferredTestCiphers() {
        String[] ciphers;
        try {
            ciphers = SSLContext.getDefault().getDefaultSSLParameters().getCipherSuites();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        ArrayList<String> ciphersMinusGcm = new ArrayList<String>();
        for (String cipher : ciphers) {
            if (cipher.contains("_GCM_")) continue;
            ciphersMinusGcm.add(cipher);
        }
        return Collections.unmodifiableList(ciphersMinusGcm);
    }

    public static String formatKeyFileContents(byte[] rawKeyText) {
        String encodedCertText;
        Base64.Encoder encoder;
        try {
            encoder = Base64.getMimeEncoder(64, LINE_SEPARATOR.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new GrpcSSLValidationException("Invalid Charset Getting Encoder.", e);
        }
        try {
            encodedCertText = new String(encoder.encode(rawKeyText), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GrpcSSLValidationException("Invalid Charset Name at key generation.", e);
        }
        return BEGIN_KEY + LINE_SEPARATOR + encodedCertText + LINE_SEPARATOR + END_KEY;
    }
}

