/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.grpc.MessageUtils;

public class ServiceResource {
    private final ObjectValue service;
    private final String functionName;
    private final BType[] paramTypes;
    private final boolean headerRequired;
    private final Scheduler scheduler;

    public ServiceResource(Scheduler scheduler, ObjectValue service, AttachedFunction function) {
        this.service = service;
        this.functionName = function.funcName;
        this.paramTypes = function.getParameterType();
        this.headerRequired = MessageUtils.headersRequired(function);
        this.scheduler = scheduler;
    }

    public ObjectValue getService() {
        return this.service;
    }

    public List<BType> getParamTypes() {
        return Collections.unmodifiableList(Arrays.asList(this.paramTypes));
    }

    public boolean isHeaderRequired() {
        return this.headerRequired;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

