/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.net.grpc.ServerMethodDefinition;
import org.ballerinalang.net.grpc.ServerServiceDefinition;

public class ServicesRegistry {
    private final List<ServerServiceDefinition> services;
    private final Map<String, ServerMethodDefinition> methods;

    private ServicesRegistry(List<ServerServiceDefinition> services, Map<String, ServerMethodDefinition> methods) {
        this.services = services;
        this.methods = methods;
    }

    public List<ServerServiceDefinition> getServices() {
        return this.services;
    }

    ServerMethodDefinition lookupMethod(String methodName) {
        return this.methods.get(methodName);
    }

    public static class Builder {
        private final HashMap<String, ServerServiceDefinition> services = new LinkedHashMap<String, ServerServiceDefinition>();

        public void addService(ServerServiceDefinition service) {
            this.services.put(service.getServiceDescriptor().getName(), service);
        }

        public ServicesRegistry build() {
            HashMap<String, ServerMethodDefinition> map = new HashMap<String, ServerMethodDefinition>();
            for (ServerServiceDefinition service : this.services.values()) {
                for (ServerMethodDefinition method : service.getMethods()) {
                    map.put(method.getMethodDescriptor().getFullMethodName(), method);
                }
            }
            return new ServicesRegistry(Collections.unmodifiableList(new ArrayList<ServerServiceDefinition>(this.services.values())), Collections.unmodifiableMap(map));
        }
    }
}

