/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import com.google.protobuf.DescriptorProtos;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.net.grpc.builder.utils.BalGenerationUtils;

public class Descriptor {
    private String descriptorKey;
    private String descriptorData;

    private Descriptor(String descriptorKey, String descriptorData) {
        this.descriptorKey = descriptorKey;
        this.descriptorData = descriptorData;
    }

    public String getKey() {
        return this.descriptorKey;
    }

    public String getData() {
        return this.descriptorData;
    }

    public static Builder newBuilder(byte[] descriptorData) {
        return new Builder(descriptorData);
    }

    public static class Builder {
        byte[] descriptorData;

        private Builder(byte[] descriptorData) {
            this.descriptorData = descriptorData;
        }

        public Descriptor build() throws IOException {
            try (ByteArrayInputStream targetStream = new ByteArrayInputStream(this.descriptorData);){
                DescriptorProtos.FileDescriptorProto fileDescriptorSet = DescriptorProtos.FileDescriptorProto.parseFrom((InputStream)targetStream);
                Descriptor descriptor = new Descriptor(fileDescriptorSet.getName(), new BString(BalGenerationUtils.bytesToHex(this.descriptorData)).stringValue());
                return descriptor;
            }
        }
    }
}

