/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import com.google.protobuf.DescriptorProtos;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.net.grpc.builder.components.EnumField;

public class EnumMessage {
    private List<EnumField> fieldList;
    private String messageName;

    private EnumMessage(String messageName, List<EnumField> fieldList) {
        this.messageName = messageName;
        this.fieldList = fieldList;
    }

    public static Builder newBuilder(DescriptorProtos.EnumDescriptorProto enumDescriptor) {
        return new Builder(enumDescriptor);
    }

    public List<EnumField> getFieldList() {
        return this.fieldList;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public static class Builder {
        private DescriptorProtos.EnumDescriptorProto enumDescriptor;

        public EnumMessage build() {
            ArrayList<EnumField> fieldList = new ArrayList<EnumField>();
            for (DescriptorProtos.EnumValueDescriptorProto fieldDescriptor : this.enumDescriptor.getValueList()) {
                EnumField field = EnumField.newBuilder(fieldDescriptor).build();
                fieldList.add(field);
            }
            return new EnumMessage(this.enumDescriptor.getName(), fieldList);
        }

        private Builder(DescriptorProtos.EnumDescriptorProto enumDescriptor) {
            this.enumDescriptor = enumDescriptor;
        }
    }
}

