/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import com.google.protobuf.DescriptorProtos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.net.grpc.builder.components.EnumMessage;
import org.ballerinalang.net.grpc.builder.components.Field;
import org.ballerinalang.net.grpc.builder.utils.BalGenerationUtils;

public class Message {
    private List<Field> fieldList;
    private String messageName;
    private Map<String, List<Message>> oneofFieldMap;
    private List<EnumMessage> enumList;

    private Message(String messageName, List<Field> fieldList) {
        this.messageName = messageName;
        this.fieldList = fieldList;
    }

    private void setOneofFieldMap(Map<String, List<Message>> oneofFieldMap) {
        this.oneofFieldMap = oneofFieldMap;
    }

    public Map<String, List<Message>> getOneofFieldMap() {
        return this.oneofFieldMap;
    }

    public List<EnumMessage> getEnumList() {
        return this.enumList;
    }

    private void setEnumList(List<EnumMessage> enumList) {
        this.enumList = enumList;
    }

    public static Builder newBuilder(DescriptorProtos.DescriptorProto messageDescriptor) {
        return new Builder(messageDescriptor);
    }

    public List<Field> getFieldList() {
        return this.fieldList;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public static class Builder {
        private DescriptorProtos.DescriptorProto messageDescriptor;

        public Message build() {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            HashMap<String, List> oneofFieldMap = new HashMap<String, List>();
            for (Object fieldDescriptorProto : this.messageDescriptor.getFieldList()) {
                if (fieldDescriptorProto.hasOneofIndex()) {
                    ArrayList<Field> tempList = new ArrayList<Field>(1);
                    tempList.add(Field.newBuilder((DescriptorProtos.FieldDescriptorProto)fieldDescriptorProto).build());
                    Message message = new Message(this.messageDescriptor.getName() + "_" + BalGenerationUtils.toCamelCase(fieldDescriptorProto.getName()), tempList);
                    String oneofField = this.messageDescriptor.getOneofDecl(fieldDescriptorProto.getOneofIndex()).getName();
                    List oneofMessageList = oneofFieldMap.computeIfAbsent(oneofField, k -> new ArrayList());
                    oneofMessageList.add(message);
                    continue;
                }
                Field field = Field.newBuilder((DescriptorProtos.FieldDescriptorProto)fieldDescriptorProto).build();
                fieldList.add(field);
            }
            ArrayList<EnumMessage> enumList = new ArrayList<EnumMessage>();
            for (DescriptorProtos.EnumDescriptorProto enumDescriptorProto : this.messageDescriptor.getEnumTypeList()) {
                EnumMessage enumMessage = EnumMessage.newBuilder(enumDescriptorProto).build();
                enumList.add(enumMessage);
            }
            Message message = new Message(this.messageDescriptor.getName(), fieldList);
            if (!oneofFieldMap.isEmpty()) {
                message.setOneofFieldMap(oneofFieldMap);
            }
            if (!enumList.isEmpty()) {
                message.setEnumList(enumList);
            }
            return message;
        }

        private Builder(DescriptorProtos.DescriptorProto messageDescriptor) {
            this.messageDescriptor = messageDescriptor;
        }
    }
}

