/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Executor;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BTypeDescValue;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.HttpCallableUnitCallback;
import org.ballerinalang.net.http.HttpDispatcher;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.util.codegen.AttachedFunctionInfo;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.observability.ObservabilityUtils;
import org.ballerinalang.util.observability.ObserverContext;
import org.ballerinalang.util.program.BLangFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class BallerinaHTTPConnectorListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(BallerinaHTTPConnectorListener.class);
    protected static final String HTTP_RESOURCE = "httpResource";
    private final HTTPServicesRegistry httpServicesRegistry;
    private final Value[] filterHolders;

    public BallerinaHTTPConnectorListener(HTTPServicesRegistry httpServicesRegistry, Value[] filterHolders) {
        this.httpServicesRegistry = httpServicesRegistry;
        this.filterHolders = filterHolders;
    }

    public void onMessage(HTTPCarbonMessage httpCarbonMessage) {
        try {
            if (this.accessed(httpCarbonMessage)) {
                HttpResource httpResource = (HttpResource)httpCarbonMessage.getProperty(HTTP_RESOURCE);
                this.extractPropertiesAndStartResourceExecution(httpCarbonMessage, httpResource);
                return;
            }
            HttpResource httpResource = HttpDispatcher.findResource(this.httpServicesRegistry, httpCarbonMessage);
            if (HttpDispatcher.shouldDiffer(httpResource, this.hasFilters())) {
                httpCarbonMessage.setProperty(HTTP_RESOURCE, (Object)httpResource);
                return;
            }
            this.extractPropertiesAndStartResourceExecution(httpCarbonMessage, httpResource);
        }
        catch (BallerinaException ex) {
            HttpUtil.handleFailure(httpCarbonMessage, new BallerinaConnectorException(ex.getMessage(), ex.getCause()));
        }
    }

    public void onError(Throwable throwable) {
        log.error("Error in http server connector" + throwable.getMessage(), throwable);
    }

    protected void extractPropertiesAndStartResourceExecution(HTTPCarbonMessage httpCarbonMessage, HttpResource httpResource) {
        boolean isTransactionInfectable = httpResource.isTransactionInfectable();
        Map<String, Object> properties = this.collectRequestProperties(httpCarbonMessage, isTransactionInfectable);
        BValue[] signatureParams = HttpDispatcher.getSignatureParameters(httpResource, httpCarbonMessage);
        WorkerExecutionContext parentCtx = new WorkerExecutionContext(httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile());
        this.invokeRequestFilters(httpCarbonMessage, signatureParams[1], this.getRequestFilterContext(httpResource), parentCtx);
        Resource balResource = httpResource.getBalResource();
        Optional observerContext = ObservabilityUtils.startServerObservation((String)"http", (String)balResource.getServiceName(), (String)balResource.getName(), null);
        observerContext.ifPresent(ctx -> {
            HashMap httpHeaders = new HashMap();
            httpCarbonMessage.getHeaders().forEach(entry -> {
                String cfr_ignored_0 = (String)httpHeaders.put(entry.getKey(), entry.getValue());
            });
            ctx.addProperty("trace_properties", httpHeaders);
            ctx.addTag("http.method", (String)httpCarbonMessage.getProperty("HTTP_METHOD"));
            ctx.addTag("protocol", (String)httpCarbonMessage.getProperty("PROTOCOL"));
            ctx.addTag("http.url", (String)httpCarbonMessage.getProperty("REQUEST_URL"));
        });
        HttpCallableUnitCallback callback = new HttpCallableUnitCallback(httpCarbonMessage);
        Executor.submit((Resource)balResource, (CallableUnitCallback)callback, properties, (ObserverContext)observerContext.orElse(null), (WorkerExecutionContext)parentCtx, (BValue[])signatureParams);
    }

    protected BValue getRequestFilterContext(HttpResource httpResource) {
        BStruct filterCtxtStruct = BLangConnectorSPIUtil.createBStruct((ProgramFile)httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"FilterContext", (Object[])new Object[0]);
        filterCtxtStruct.setRefField(0, (BRefType)new BTypeDescValue((BType)httpResource.getBalResource().getResourceInfo().getServiceInfo().getType()));
        filterCtxtStruct.setStringField(0, httpResource.getParentService().getName());
        filterCtxtStruct.setStringField(1, httpResource.getName());
        return filterCtxtStruct;
    }

    protected boolean accessed(HTTPCarbonMessage httpCarbonMessage) {
        return httpCarbonMessage.getProperty(HTTP_RESOURCE) != null;
    }

    private Map<String, Object> collectRequestProperties(HTTPCarbonMessage httpCarbonMessage, boolean isInfectable) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (httpCarbonMessage.getProperty("SRC_HANDLER") != null) {
            Object srcHandler = httpCarbonMessage.getProperty("SRC_HANDLER");
            properties.put("SRC_HANDLER", srcHandler);
        }
        String txnId = httpCarbonMessage.getHeader("x-b7a-xid");
        String registerAtUrl = httpCarbonMessage.getHeader("x-b7a-register-at");
        if (!isInfectable && txnId != null) {
            throw new BallerinaConnectorException("Cannot create transaction context: resource is not transactionInfectable");
        }
        if (isInfectable && txnId != null && registerAtUrl != null) {
            properties.put("globalTransactionId", txnId);
            properties.put("transactionUrl", registerAtUrl);
            return properties;
        }
        properties.put("REMOTE_ADDRESS", httpCarbonMessage.getProperty("REMOTE_ADDRESS"));
        properties.put("ORIGIN_HOST", httpCarbonMessage.getHeader("ORIGIN_HOST"));
        properties.put("POOLED_BYTE_BUFFER_FACTORY", httpCarbonMessage.getHeader("POOLED_BYTE_BUFFER_FACTORY"));
        return properties;
    }

    protected void invokeRequestFilters(HTTPCarbonMessage httpCarbonMessage, BValue requestObject, BValue filterCtxt, WorkerExecutionContext parentCtx) {
        if (!this.hasFilters()) {
            return;
        }
        for (Value filterHolder : this.filterHolders) {
            BStructType structType = (BStructType)filterHolder.getVMValue().getType();
            BValue[] returnValue = BLangFunctions.invokeCallable((CallableUnitInfo)((AttachedFunctionInfo)structType.structInfo.funcInfoEntries.get((Object)"filterRequest")).functionInfo, (WorkerExecutionContext)parentCtx, (BValue[])new BValue[]{filterHolder.getVMValue(), requestObject, filterCtxt});
            BStruct filterResultStruct = (BStruct)returnValue[0];
            if (filterResultStruct.getBooleanField(0) != 0) continue;
            int filterStatusCode = Math.toIntExact(filterResultStruct.getIntField(0));
            int responseStatusCode = filterStatusCode >= 400 && filterStatusCode < 500 ? filterStatusCode : 400;
            httpCarbonMessage.setProperty("HTTP_STATUS_CODE", (Object)responseStatusCode);
            throw new BallerinaException("Request failed: " + filterResultStruct.getStringField(0));
        }
    }

    protected boolean hasFilters() {
        return this.filterHolders != null && this.filterHolders.length > 0;
    }
}

