/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ballerinalang.net.http.CorsHeaders;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.uri.DispatcherUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class CorsHeaderGenerator {
    private static final Pattern spacePattern = Pattern.compile(" ");
    private static final Pattern fieldCommaPattern = Pattern.compile(",");
    private static final Logger bLog = LoggerFactory.getLogger((String)"ballerina");
    private static final String action = "Failed to process CORS : ";

    public static void process(HTTPCarbonMessage requestMsg, HTTPCarbonMessage responseMsg, boolean isSimpleRequest) {
        boolean isCorsResponseHeadersAvailable = false;
        Map<String, String> responseHeaders = null;
        if (isSimpleRequest) {
            CorsHeaders resourceCors = (CorsHeaders)requestMsg.getProperty("RESOURCES_CORS");
            String origin = requestMsg.getHeader(HttpHeaderNames.ORIGIN.toString());
            if (origin == null || resourceCors == null || !resourceCors.isAvailable()) {
                return;
            }
            responseHeaders = CorsHeaderGenerator.processSimpleRequest(origin, resourceCors);
            if (responseHeaders != null) {
                isCorsResponseHeadersAvailable = true;
            }
        } else {
            String origin = requestMsg.getHeader(HttpHeaderNames.ORIGIN.toString());
            if (origin == null) {
                return;
            }
            responseHeaders = CorsHeaderGenerator.processPreflightRequest(origin, requestMsg);
            if (responseHeaders != null) {
                isCorsResponseHeadersAvailable = true;
            }
        }
        if (isCorsResponseHeadersAvailable) {
            responseHeaders.entrySet().stream().forEach(header -> responseMsg.setHeader((String)header.getKey(), (String)header.getValue()));
            responseMsg.removeHeader(HttpHeaderNames.ALLOW.toString());
        }
    }

    private static Map<String, String> processSimpleRequest(String origin, CorsHeaders resourceCors) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        List<String> requestOrigins = CorsHeaderGenerator.getOriginValues(origin);
        if (requestOrigins == null || requestOrigins.size() == 0) {
            bLog.info("Failed to process CORS : origin header field parsing failed");
            return null;
        }
        if (!CorsHeaderGenerator.isEffectiveOrigin(requestOrigins, resourceCors.getAllowOrigins())) {
            bLog.info("Failed to process CORS : not allowed origin");
            return null;
        }
        CorsHeaderGenerator.setAllowOriginAndCredentials(requestOrigins, resourceCors, responseHeaders);
        CorsHeaderGenerator.setExposedAllowedHeaders(resourceCors, responseHeaders);
        return responseHeaders;
    }

    private static Map<String, String> processPreflightRequest(String originValue, HTTPCarbonMessage cMsg) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        List<String> requestOrigins = CorsHeaderGenerator.getOriginValues(originValue);
        if (requestOrigins == null || requestOrigins.size() != 1) {
            bLog.info("Failed to process CORS : origin header field parsing failed");
            return null;
        }
        String origin = requestOrigins.get(0);
        List<String> requestMethods = CorsHeaderGenerator.getHeaderValues(HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD.toString(), cMsg);
        if (requestMethods == null || requestMethods.size() != 1) {
            String error = requestMethods == null ? "Access-Control-Request-Method header is unavailable" : "Access-Control-Request-Method header value must be single-valued";
            bLog.info(action + error);
            return null;
        }
        String requestMethod = requestMethods.get(0);
        CorsHeaders resourceCors = CorsHeaderGenerator.getResourceCors(cMsg, requestMethod);
        if (resourceCors == null || !resourceCors.isAvailable()) {
            String error = resourceCors == null ? "access control request method not allowed" : "CORS headers not declared properly";
            bLog.info(action + error);
            return null;
        }
        if (!CorsHeaderGenerator.isEffectiveMethod(requestMethod, resourceCors.getAllowMethods())) {
            bLog.info("Failed to process CORS : access control request method not allowed");
            return null;
        }
        if (!CorsHeaderGenerator.isEffectiveOrigin(Arrays.asList(origin), resourceCors.getAllowOrigins())) {
            bLog.info("Failed to process CORS : origin not allowed");
            return null;
        }
        List<String> requestHeaders = CorsHeaderGenerator.getHeaderValues(HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS.toString(), cMsg);
        if (!CorsHeaderGenerator.isEffectiveHeader(requestHeaders, resourceCors.getAllowHeaders())) {
            bLog.info("Failed to process CORS : header field parsing failed");
            return null;
        }
        CorsHeaderGenerator.setAllowOriginAndCredentials(Arrays.asList(origin), resourceCors, responseHeaders);
        responseHeaders.put(HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), requestMethod);
        if (requestHeaders != null) {
            responseHeaders.put(HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString(), DispatcherUtil.concatValues(requestHeaders, false));
        }
        responseHeaders.put(HttpHeaderNames.ACCESS_CONTROL_MAX_AGE.toString(), String.valueOf(resourceCors.getMaxAge()));
        return responseHeaders;
    }

    private static boolean isEffectiveOrigin(List<String> requestOrigins, List<String> resourceOrigins) {
        if (resourceOrigins.size() == 1 && resourceOrigins.get(0).equals("*")) {
            return true;
        }
        return resourceOrigins.containsAll(requestOrigins);
    }

    private static boolean isEffectiveHeader(List<String> requestHeaders, List<String> resourceHeaders) {
        if (resourceHeaders == null || requestHeaders == null) {
            return true;
        }
        TreeSet<String> headersSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        headersSet.addAll(resourceHeaders);
        return headersSet.containsAll(requestHeaders);
    }

    private static boolean isEffectiveMethod(String requestMethod, List<String> resourceMethods) {
        if (resourceMethods.size() == 1 && resourceMethods.get(0).equals("*")) {
            return true;
        }
        for (String method : resourceMethods) {
            if (!requestMethod.equals(method)) continue;
            return true;
        }
        return false;
    }

    private static CorsHeaders getResourceCors(HTTPCarbonMessage cMsg, String requestMethod) {
        List resources = (List)cMsg.getProperty("PREFLIGHT_RESOURCES");
        if (resources == null) {
            return null;
        }
        for (HttpResource resource : resources) {
            if (resource.getMethods() == null || !resource.getMethods().contains(requestMethod)) continue;
            return resource.getCorsHeaders();
        }
        if (!requestMethod.equals("HEAD")) {
            return null;
        }
        for (HttpResource resource : resources) {
            if (resource.getMethods() == null || !resource.getMethods().contains("GET")) continue;
            return resource.getCorsHeaders();
        }
        return null;
    }

    private static List<String> getHeaderValues(String key, HTTPCarbonMessage cMsg) {
        String value = cMsg.getHeader(key);
        if (value != null) {
            String[] values = fieldCommaPattern.split(value);
            return Arrays.stream(values).collect(Collectors.toList());
        }
        return null;
    }

    private static void setExposedAllowedHeaders(CorsHeaders resCors, Map<String, String> respHeaders) {
        List<String> exposeHeaders = resCors.getExposeHeaders();
        if (exposeHeaders == null) {
            return;
        }
        String exposeHeaderResponse = DispatcherUtil.concatValues(exposeHeaders, false);
        if (!exposeHeaderResponse.isEmpty()) {
            respHeaders.put(HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS.toString(), exposeHeaderResponse);
        }
    }

    private static void setAllowOriginAndCredentials(List<String> effectiveOrigins, CorsHeaders resCors, Map<String, String> responseHeaders) {
        int allowCreds = resCors.getAllowCredentials();
        if (allowCreds == 1) {
            responseHeaders.put(HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS.toString(), String.valueOf(true));
        }
        responseHeaders.put(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), DispatcherUtil.concatValues(effectiveOrigins, true));
    }

    private static List<String> getOriginValues(String originValue) {
        String[] origins = spacePattern.split(originValue);
        return Arrays.stream(origins).filter(value -> value.contains("://")).collect(Collectors.toList());
    }
}

