/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;

public class CorsHeaders {
    private static final String ALLOW_CREDENTIALS_FIELD = "allowCredentials";
    private static final String ALLOW_HEADERS_FIELD = "allowHeaders";
    private static final String ALLOW_METHODS_FIELD = "allowMethods";
    private static final String ALLOWS_ORIGINS_FIELD = "allowOrigins";
    private static final String EXPOSE_HEADERS_FIELD = "exposeHeaders";
    private static final String MAX_AGE_FIELD = "maxAge";
    private boolean available = false;
    private List<String> allowOrigins;
    private int allowCredentials = -1;
    private List<String> allowMethods;
    private List<String> allowHeaders;
    private long maxAge = -1L;
    private List<String> exposeHeaders;

    public boolean isAvailable() {
        return this.available;
    }

    public List<String> getAllowOrigins() {
        return this.allowOrigins;
    }

    public void setAllowOrigins(List<String> allowOrigins) {
        if (allowOrigins != null) {
            this.available = true;
        }
        this.allowOrigins = allowOrigins;
    }

    public int getAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(int allowCredentials) {
        if (allowCredentials > 0) {
            this.available = true;
        }
        this.allowCredentials = allowCredentials;
    }

    public List<String> getAllowMethods() {
        return this.allowMethods;
    }

    public void setAllowMethods(List<String> allowMethods) {
        if (allowMethods != null) {
            this.available = true;
        }
        this.allowMethods = allowMethods;
    }

    public List<String> getAllowHeaders() {
        return this.allowHeaders;
    }

    public void setAllowHeaders(List<String> allowHeaders) {
        if (allowHeaders != null) {
            this.available = true;
        }
        this.allowHeaders = allowHeaders;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        if (maxAge >= 0L) {
            this.available = true;
        }
        this.maxAge = maxAge;
    }

    public List<String> getExposeHeaders() {
        return this.exposeHeaders;
    }

    public void setExposeHeaders(List<String> exposeHeaders) {
        if (exposeHeaders != null) {
            this.available = true;
        }
        this.exposeHeaders = exposeHeaders;
    }

    public static CorsHeaders buildCorsHeaders(Struct corsConfig) {
        CorsHeaders corsHeaders = new CorsHeaders();
        if (corsConfig == null) {
            return corsHeaders;
        }
        corsHeaders.setAllowHeaders(CorsHeaders.getAsStringList(corsConfig.getArrayField(ALLOW_HEADERS_FIELD)));
        corsHeaders.setAllowMethods(CorsHeaders.getAsStringList(corsConfig.getArrayField(ALLOW_METHODS_FIELD)));
        corsHeaders.setAllowOrigins(CorsHeaders.getAsStringList(corsConfig.getArrayField(ALLOWS_ORIGINS_FIELD)));
        corsHeaders.setExposeHeaders(CorsHeaders.getAsStringList(corsConfig.getArrayField(EXPOSE_HEADERS_FIELD)));
        corsHeaders.setAllowCredentials(corsConfig.getBooleanField(ALLOW_CREDENTIALS_FIELD) ? 1 : 0);
        corsHeaders.setMaxAge(corsConfig.getIntField(MAX_AGE_FIELD));
        return corsHeaders;
    }

    private static List<String> getAsStringList(Value[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesList = new ArrayList<String>();
        for (Value val : values) {
            valuesList.add(val.getStringValue().trim());
        }
        return !valuesList.isEmpty() ? valuesList : null;
    }
}

