/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.runtime.message.MessageDataSource;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class DataContext {
    public Context context;
    public CallableUnitCallback callback;
    private HTTPCarbonMessage correlatedMessage;

    public DataContext(Context context, CallableUnitCallback callback, HTTPCarbonMessage correlatedMessage) {
        this.context = context;
        this.callback = callback;
        this.correlatedMessage = correlatedMessage;
    }

    public void notifyReply(BStruct response, BStruct httpConnectorError) {
        BStruct requestStruct;
        if (this.correlatedMessage != null && (requestStruct = (BStruct)this.context.getNullableRefArgument(1)) != null) {
            BStruct entityStruct = MimeUtil.extractEntity((BStruct)requestStruct);
            if (entityStruct != null) {
                MessageDataSource messageDataSource = EntityBodyHandler.getMessageDataSource((BStruct)entityStruct);
                if (messageDataSource == null && EntityBodyHandler.getByteChannel((BStruct)entityStruct) == null) {
                    this.correlatedMessage.addHttpContent((HttpContent)new DefaultLastHttpContent());
                } else {
                    this.correlatedMessage.waitAndReleaseAllEntities();
                }
            } else {
                this.correlatedMessage.addHttpContent((HttpContent)new DefaultLastHttpContent());
            }
        }
        if (response != null) {
            this.context.setReturnValues(new BValue[]{response});
        } else if (httpConnectorError != null) {
            this.context.setReturnValues(new BValue[]{httpConnectorError});
        } else {
            BStruct err = BLangConnectorSPIUtil.createBStruct((Context)this.context, (String)"ballerina.http", (String)"HttpConnectorError", (Object[])new Object[]{"HttpClient failed"});
            this.context.setReturnValues(new BValue[]{err});
        }
        this.callback.notifySuccess();
    }

    public void notifyOutboundResponseStatus(BStruct httpConnectorError) {
        if (httpConnectorError == null) {
            this.context.setReturnValues(new BValue[0]);
        } else {
            this.context.setReturnValues(new BValue[]{httpConnectorError});
        }
        this.callback.notifySuccess();
    }

    public HTTPCarbonMessage getOutboundRequest() {
        return this.correlatedMessage;
    }
}

