/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ballerinalang.connector.api.Annotation;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.WebSocketService;
import org.ballerinalang.net.http.WebSocketServicesRegistry;
import org.ballerinalang.net.http.WebSocketUtil;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServicesRegistry {
    private static final Logger logger = LoggerFactory.getLogger(HTTPServicesRegistry.class);
    protected final Map<String, HttpService> servicesInfoMap = new ConcurrentHashMap<String, HttpService>();
    protected CopyOnWriteArrayList<String> sortedServiceURIs = new CopyOnWriteArrayList();
    private final WebSocketServicesRegistry webSocketServicesRegistry;

    public HTTPServicesRegistry(WebSocketServicesRegistry webSocketServicesRegistry) {
        this.webSocketServicesRegistry = webSocketServicesRegistry;
    }

    public HttpService getServiceInfo(String basepath) {
        return this.servicesInfoMap.get(basepath);
    }

    public Map<String, HttpService> getServicesInfoByInterface() {
        return this.servicesInfoMap;
    }

    public void registerService(Service service) {
        List<HttpService> httpServices = HttpService.buildHttpService(service);
        for (HttpService httpService : httpServices) {
            String basePath = httpService.getBasePath();
            if (this.servicesInfoMap.containsKey(basePath)) {
                throw new BallerinaException("Service registration failed: two services have the same basePath : " + basePath);
            }
            this.servicesInfoMap.put(basePath, httpService);
            String errLog = String.format("Service deployed : %s with context %s", service.getName(), basePath);
            logger.info(errLog);
            this.sortedServiceURIs.add(basePath);
            this.sortedServiceURIs.sort((basePath1, basePath2) -> basePath2.length() - basePath1.length());
            this.registerUpgradableWebSocketService(httpService);
        }
    }

    private void registerUpgradableWebSocketService(HttpService httpService) {
        httpService.getUpgradeToWebSocketResources().forEach(upgradeToWebSocketResource -> {
            ProgramFile programFile = WebSocketUtil.getProgramFile(upgradeToWebSocketResource);
            Annotation resourceConfigAnnotation = HttpUtil.getResourceConfigAnnotation(upgradeToWebSocketResource, "ballerina.http");
            if (resourceConfigAnnotation == null) {
                throw new BallerinaException("Cannot register WebSocket service without resource config annotation in resource " + upgradeToWebSocketResource.getName());
            }
            Struct webSocketConfig = resourceConfigAnnotation.getValue().getStructField("webSocketUpgrade");
            Value serviceType = webSocketConfig.getTypeField("upgradeService");
            Service webSocketTypeService = BLangConnectorSPIUtil.getServiceFromType((ProgramFile)programFile, (Value)serviceType);
            WebSocketService webSocketService = new WebSocketService(this.sanitizeBasePath(httpService.getBasePath()), (Resource)upgradeToWebSocketResource, webSocketTypeService);
            this.webSocketServicesRegistry.registerService(webSocketService);
        });
    }

    private String sanitizeBasePath(String basePath) {
        if (!(basePath = basePath.trim()).startsWith("/")) {
            basePath = "/".concat(basePath);
        }
        if (basePath.endsWith("/") && basePath.length() != 1) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return basePath;
    }

    public String findTheMostSpecificBasePath(String requestURIPath, Map<String, HttpService> services) {
        for (String key : this.sortedServiceURIs) {
            if (!requestURIPath.toLowerCase().contains(key.toString().toLowerCase())) continue;
            if (requestURIPath.length() <= key.toString().length()) {
                return key.toString();
            }
            if (requestURIPath.charAt(key.toString().length()) != '/') continue;
            return key.toString();
        }
        if (services.containsKey("/")) {
            return "/";
        }
        return null;
    }
}

