/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.net.http.HttpUtil;
import org.wso2.transport.http.netty.config.ListenerConfiguration;
import org.wso2.transport.http.netty.config.SenderConfiguration;
import org.wso2.transport.http.netty.config.TransportProperty;
import org.wso2.transport.http.netty.config.TransportsConfiguration;
import org.wso2.transport.http.netty.contract.HttpWsConnectorFactory;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.websocket.WebSocketClientConnector;
import org.wso2.transport.http.netty.contract.websocket.WsClientConnectorConfig;
import org.wso2.transport.http.netty.listener.ServerBootstrapConfiguration;
import org.wso2.transport.http.netty.message.HTTPConnectorUtil;

public class HttpConnectionManager {
    private static HttpConnectionManager instance = new HttpConnectionManager();
    private Map<String, ServerConnector> startupDelayedHTTPServerConnectors = new HashMap<String, ServerConnector>();
    private Map<String, HttpServerConnectorContext> serverConnectorPool = new HashMap<String, HttpServerConnectorContext>();
    private ServerBootstrapConfiguration serverBootstrapConfiguration;
    private TransportsConfiguration trpConfig;
    private HttpWsConnectorFactory httpConnectorFactory = HttpUtil.createHttpWsConnectionFactory();

    private HttpConnectionManager() {
        this.trpConfig = this.buildDefaultTransportConfig();
        this.serverBootstrapConfiguration = HTTPConnectorUtil.getServerBootstrapConfiguration((Set)this.trpConfig.getTransportProperties());
    }

    public static HttpConnectionManager getInstance() {
        return instance;
    }

    public ServerConnector createHttpServerConnector(ListenerConfiguration listenerConfig) {
        String listenerInterface = listenerConfig.getHost() + ":" + listenerConfig.getPort();
        HttpServerConnectorContext httpServerConnectorContext = this.serverConnectorPool.get(listenerInterface);
        if (httpServerConnectorContext != null) {
            if (this.checkForConflicts(listenerConfig, httpServerConnectorContext)) {
                throw new BallerinaConnectorException("Conflicting configuration detected for listener configuration id " + listenerConfig.getId());
            }
            httpServerConnectorContext.incrementReferenceCount();
            return httpServerConnectorContext.getServerConnector();
        }
        if (this.isHTTPTraceLoggerEnabled()) {
            listenerConfig.setHttpTraceLogEnabled(true);
        }
        if (this.isHTTPAccessLoggerEnabled()) {
            listenerConfig.setHttpAccessLogEnabled(true);
        }
        this.serverBootstrapConfiguration = HTTPConnectorUtil.getServerBootstrapConfiguration((Set)this.trpConfig.getTransportProperties());
        ServerConnector serverConnector = this.httpConnectorFactory.createServerConnector(this.serverBootstrapConfiguration, listenerConfig);
        httpServerConnectorContext = new HttpServerConnectorContext(serverConnector, listenerConfig);
        this.serverConnectorPool.put(serverConnector.getConnectorID(), httpServerConnectorContext);
        httpServerConnectorContext.incrementReferenceCount();
        this.addStartupDelayedHTTPServerConnector(listenerInterface, serverConnector);
        return serverConnector;
    }

    public void addStartupDelayedHTTPServerConnector(String id, ServerConnector serverConnector) {
        this.startupDelayedHTTPServerConnectors.put(id, serverConnector);
    }

    private boolean checkForConflicts(ListenerConfiguration listenerConfiguration, HttpServerConnectorContext context) {
        if (context == null) {
            return false;
        }
        if (listenerConfiguration.getScheme().equalsIgnoreCase("https")) {
            ListenerConfiguration config = context.getListenerConfiguration();
            if (!(listenerConfiguration.getKeyStoreFile().equals(config.getKeyStoreFile()) && listenerConfiguration.getKeyStorePass().equals(config.getKeyStorePass()) && listenerConfiguration.getCertPass().equals(config.getCertPass()))) {
                return true;
            }
        }
        return false;
    }

    public WebSocketClientConnector getWebSocketClientConnector(WsClientConnectorConfig configuration) {
        return this.httpConnectorFactory.createWsClientConnector(configuration);
    }

    public TransportsConfiguration getTransportConfig() {
        return this.trpConfig;
    }

    public boolean isHTTPTraceLoggerEnabled() {
        return Boolean.parseBoolean(System.getProperty("http.tracelog.enabled"));
    }

    private boolean isHTTPAccessLoggerEnabled() {
        return Boolean.parseBoolean(System.getProperty("http.accesslog.enabled"));
    }

    private TransportsConfiguration buildDefaultTransportConfig() {
        TransportsConfiguration transportsConfiguration = new TransportsConfiguration();
        SenderConfiguration httpSender = new SenderConfiguration("http-sender");
        SenderConfiguration httpsSender = new SenderConfiguration("https-sender");
        httpsSender.setScheme("https");
        httpsSender.setTrustStoreFile(String.valueOf(Paths.get(System.getProperty("ballerina.home"), "bre", "security", "ballerinaTruststore.p12")));
        httpsSender.setTrustStorePass("ballerina");
        TransportProperty latencyMetrics = new TransportProperty();
        latencyMetrics.setName("latency.metrics.enabled");
        latencyMetrics.setValue((Object)true);
        TransportProperty serverSocketTimeout = new TransportProperty();
        serverSocketTimeout.setName("server.bootstrap.socket.timeout");
        serverSocketTimeout.setValue((Object)60);
        TransportProperty clientSocketTimeout = new TransportProperty();
        clientSocketTimeout.setName("client.bootstrap.socket.timeout");
        clientSocketTimeout.setValue((Object)60);
        HashSet<SenderConfiguration> senderConfigurationSet = new HashSet<SenderConfiguration>();
        senderConfigurationSet.add(httpSender);
        senderConfigurationSet.add(httpsSender);
        transportsConfiguration.setSenderConfigurations(senderConfigurationSet);
        HashSet<TransportProperty> transportPropertySet = new HashSet<TransportProperty>();
        transportPropertySet.add(latencyMetrics);
        transportPropertySet.add(serverSocketTimeout);
        transportPropertySet.add(clientSocketTimeout);
        transportsConfiguration.setTransportProperties(transportPropertySet);
        return transportsConfiguration;
    }

    private String makeFirstLetterLowerCase(String str) {
        if (str == null) {
            return null;
        }
        char[] ch = str.toCharArray();
        ch[0] = Character.toLowerCase(ch[0]);
        return new String(ch);
    }

    private static class HttpServerConnectorContext {
        private ServerConnector serverConnector;
        private ListenerConfiguration listenerConfiguration;
        private int referenceCount = 0;

        HttpServerConnectorContext(ServerConnector serverConnector, ListenerConfiguration listenerConfiguration) {
            this.serverConnector = serverConnector;
            this.listenerConfiguration = listenerConfiguration;
        }

        void incrementReferenceCount() {
            ++this.referenceCount;
        }

        void decrementReferenceCount() {
            --this.referenceCount;
        }

        ServerConnector getServerConnector() {
            return this.serverConnector;
        }

        ListenerConfiguration getListenerConfiguration() {
            return this.listenerConfiguration;
        }

        int getReferenceCount() {
            return this.referenceCount;
        }
    }
}

