/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.util.JSONUtils;
import org.ballerinalang.model.values.BBlob;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpResourceDispatcher;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.SignatureParams;
import org.ballerinalang.net.http.caching.RequestCacheControlStruct;
import org.ballerinalang.net.uri.URIUtil;
import org.ballerinalang.runtime.message.BlobDataSource;
import org.ballerinalang.runtime.message.MessageDataSource;
import org.ballerinalang.runtime.message.StringDataSource;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class HttpDispatcher {
    private static final Logger breLog = LoggerFactory.getLogger(HttpDispatcher.class);

    protected static HttpService findService(HTTPServicesRegistry servicesRegistry, HTTPCarbonMessage inboundReqMsg) {
        try {
            Map<String, HttpService> servicesOnInterface = servicesRegistry.getServicesInfoByInterface();
            String rawUri = (String)inboundReqMsg.getProperty("TO");
            inboundReqMsg.setProperty("RAW_URI", (Object)rawUri);
            HashMap<String, Map<String, String>> matrixParams = new HashMap<String, Map<String, String>>();
            String uriWithoutMatrixParams = URIUtil.extractMatrixParams(rawUri, matrixParams);
            inboundReqMsg.setProperty("TO", (Object)uriWithoutMatrixParams);
            inboundReqMsg.setProperty("MATRIX_PARAMS", matrixParams);
            URI validatedUri = HttpDispatcher.getValidatedURI(uriWithoutMatrixParams);
            String basePath = servicesRegistry.findTheMostSpecificBasePath(validatedUri.getPath(), servicesOnInterface);
            if (basePath == null) {
                inboundReqMsg.setProperty("HTTP_STATUS_CODE", (Object)404);
                throw new BallerinaConnectorException("no matching service found for path : " + validatedUri.getRawPath());
            }
            HttpService service = servicesOnInterface.get(basePath);
            HttpDispatcher.setInboundReqProperties(inboundReqMsg, validatedUri, basePath);
            return service;
        }
        catch (Throwable e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
    }

    private static void setInboundReqProperties(HTTPCarbonMessage inboundReqMsg, URI requestUri, String basePath) {
        String subPath = URIUtil.getSubPath(requestUri.getPath(), basePath);
        inboundReqMsg.setProperty("BASE_PATH", (Object)basePath);
        inboundReqMsg.setProperty("SUB_PATH", (Object)subPath);
        inboundReqMsg.setProperty("QUERY_STR", (Object)requestUri.getQuery());
        inboundReqMsg.setProperty("RAW_QUERY_STR", (Object)requestUri.getRawQuery());
    }

    private static URI getValidatedURI(String uriStr) {
        URI requestUri;
        try {
            requestUri = URI.create(uriStr);
        }
        catch (IllegalArgumentException e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
        return requestUri;
    }

    private static String getInterface(HTTPCarbonMessage inboundRequest) {
        String interfaceId = (String)inboundRequest.getProperty("listener.interface.id");
        if (interfaceId == null) {
            if (breLog.isDebugEnabled()) {
                breLog.debug("Interface id not found on the message, hence using the default interface");
            }
            interfaceId = "0.0.0.0:8080";
        }
        return interfaceId;
    }

    protected static void handleError(HTTPCarbonMessage cMsg, Throwable throwable) {
        String errorMsg = throwable.getMessage();
        breLog.error("error: " + errorMsg, throwable);
        try {
            HttpUtil.handleFailure(cMsg, new BallerinaConnectorException(errorMsg, throwable.getCause()));
        }
        catch (Exception e) {
            breLog.error("Cannot handle error using the error handler for: " + e.getMessage(), (Throwable)e);
        }
    }

    public static HttpResource findResource(HTTPServicesRegistry servicesRegistry, HTTPCarbonMessage httpCarbonMessage) {
        HttpResource resource = null;
        String protocol = (String)httpCarbonMessage.getProperty("PROTOCOL");
        if (protocol == null) {
            throw new BallerinaConnectorException("protocol not defined in the incoming request");
        }
        try {
            HttpService service = HttpDispatcher.findService(servicesRegistry, httpCarbonMessage);
            if (service == null) {
                throw new BallerinaConnectorException("no Service found to handle the service request");
            }
            resource = HttpResourceDispatcher.findResource(service, httpCarbonMessage);
        }
        catch (Throwable throwable) {
            HttpDispatcher.handleError(httpCarbonMessage, throwable);
        }
        return resource;
    }

    public static BValue[] getSignatureParameters(HttpResource httpResource, HTTPCarbonMessage httpCarbonMessage) {
        BStruct serviceEndpoint = BLangConnectorSPIUtil.createBStruct((ProgramFile)httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"Listener", (Object[])new Object[0]);
        BStruct connection = BLangConnectorSPIUtil.createBStruct((ProgramFile)httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"Connection", (Object[])new Object[0]);
        BStruct inRequest = BLangConnectorSPIUtil.createBStruct((ProgramFile)httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"Request", (Object[])new Object[0]);
        BStruct inRequestEntity = BLangConnectorSPIUtil.createBStruct((ProgramFile)httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.mime", (String)"Entity", (Object[])new Object[0]);
        BStruct mediaType = BLangConnectorSPIUtil.createBStruct((ProgramFile)httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.mime", (String)"MediaType", (Object[])new Object[0]);
        BStruct cacheControlStruct = BLangConnectorSPIUtil.createBStruct((ProgramFile)httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"RequestCacheControl", (Object[])new Object[0]);
        RequestCacheControlStruct requestCacheControl = new RequestCacheControlStruct(cacheControlStruct);
        HttpUtil.enrichServiceEndpointInfo(serviceEndpoint, httpCarbonMessage, httpResource);
        HttpUtil.enrichConnectionInfo(connection, httpCarbonMessage);
        serviceEndpoint.setRefField(0, (BRefType)connection);
        HttpUtil.enrichConnectionInfo(connection, httpCarbonMessage);
        HttpUtil.populateInboundRequest(inRequest, inRequestEntity, mediaType, httpCarbonMessage, requestCacheControl);
        SignatureParams signatureParams = httpResource.getSignatureParams();
        BValue[] bValues = new BValue[signatureParams.getParamCount()];
        bValues[0] = serviceEndpoint;
        bValues[1] = inRequest;
        if (signatureParams.getParamCount() == 2) {
            return bValues;
        }
        Map resourceArgumentValues = (Map)httpCarbonMessage.getProperty("RESOURCE_ARGS");
        for (int i = 0; i < signatureParams.getPathParams().size(); ++i) {
            String argumentValue = (String)resourceArgumentValues.get(signatureParams.getPathParams().get(i).getVarName());
            if (argumentValue != null) {
                try {
                    argumentValue = URLDecoder.decode(argumentValue, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            bValues[i + 2] = new BString(argumentValue);
        }
        if (signatureParams.getEntityBody() == null) {
            return bValues;
        }
        try {
            bValues[bValues.length - 1] = HttpDispatcher.populateAndGetEntityBody(httpResource, inRequest, inRequestEntity, signatureParams.getEntityBody().getVarType());
        }
        catch (BallerinaException ex) {
            httpCarbonMessage.setProperty("HTTP_STATUS_CODE", (Object)"400");
            throw new BallerinaConnectorException("data binding failed: " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new BallerinaException(ex.getMessage());
        }
        return bValues;
    }

    private static BValue populateAndGetEntityBody(HttpResource httpResource, BStruct inRequest, BStruct inRequestEntity, BType entityBodyType) throws IOException {
        HttpUtil.populateEntityBody(null, inRequest, inRequestEntity, true);
        try {
            switch (entityBodyType.getTag()) {
                case 3: {
                    StringDataSource stringDataSource = EntityBodyHandler.constructStringDataSource((BStruct)inRequestEntity);
                    EntityBodyHandler.addMessageDataSource((BStruct)inRequestEntity, (MessageDataSource)stringDataSource);
                    return stringDataSource != null ? new BString(stringDataSource.getMessageAsString()) : null;
                }
                case 9: {
                    BJSON bjson = EntityBodyHandler.constructJsonDataSource((BStruct)inRequestEntity);
                    EntityBodyHandler.addMessageDataSource((BStruct)inRequestEntity, (MessageDataSource)bjson);
                    return bjson;
                }
                case 8: {
                    BXML bxml = EntityBodyHandler.constructXmlDataSource((BStruct)inRequestEntity);
                    EntityBodyHandler.addMessageDataSource((BStruct)inRequestEntity, (MessageDataSource)bxml);
                    return bxml;
                }
                case 5: {
                    BlobDataSource blobDataSource = EntityBodyHandler.constructBlobDataSource((BStruct)inRequestEntity);
                    EntityBodyHandler.addMessageDataSource((BStruct)inRequestEntity, (MessageDataSource)blobDataSource);
                    return new BBlob(blobDataSource != null ? blobDataSource.getValue() : new byte[]{});
                }
                case 15: {
                    BJSON bjson = EntityBodyHandler.constructJsonDataSource((BStruct)inRequestEntity);
                    EntityBodyHandler.addMessageDataSource((BStruct)inRequestEntity, (MessageDataSource)bjson);
                    try {
                        return JSONUtils.convertJSONToStruct((BJSON)bjson, (BStructType)((BStructType)entityBodyType));
                    }
                    catch (NullPointerException ex) {
                        throw new BallerinaConnectorException("cannot convert payload to struct type: " + entityBodyType.getName());
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new BallerinaConnectorException("Error in reading payload : " + ex.getMessage());
        }
        return null;
    }

    public static boolean shouldDiffer(HttpResource httpResource, boolean hasFilters) {
        return httpResource != null && httpResource.getSignatureParams().getEntityBody() != null || hasFilters;
    }
}

