/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.connector.api.Annotation;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.net.http.CorsHeaders;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.http.SignatureParams;
import org.ballerinalang.net.uri.DispatcherUtil;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResource {
    private static final Logger log = LoggerFactory.getLogger(HttpResource.class);
    private static final String METHODS_FIELD = "methods";
    private static final String PATH_FIELD = "path";
    private static final String BODY_FIELD = "body";
    private static final String CONSUMES_FIELD = "consumes";
    private static final String PRODUCES_FIELD = "produces";
    private static final String CORS_FIELD = "cors";
    private static final String TRANSACTION_INFECTABLE_FIELD = "transactionInfectable";
    private Resource balResource;
    private List<String> methods;
    private String path;
    private String entityBodyAttribute;
    private List<String> consumes;
    private List<String> produces;
    private List<String> producesSubTypes;
    private CorsHeaders corsHeaders;
    private SignatureParams signatureParams;
    private HttpService parentService;
    private boolean transactionInfectable = true;

    protected HttpResource(Resource resource, HttpService parentService) {
        this.balResource = resource;
        this.parentService = parentService;
        this.producesSubTypes = new ArrayList<String>();
    }

    public String getName() {
        return this.balResource.getName();
    }

    public String getServiceName() {
        return this.balResource.getServiceName();
    }

    public SignatureParams getSignatureParams() {
        return this.signatureParams;
    }

    public HttpService getParentService() {
        return this.parentService;
    }

    public Resource getBalResource() {
        return this.balResource;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String resourcePath) {
        if (resourcePath == null || resourcePath.isEmpty()) {
            log.debug("Path not specified in the Resource instance, using default sub path");
            this.path = this.balResource.getName();
        } else {
            this.path = resourcePath;
        }
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
        if (produces != null) {
            List<String> subAttributeValues = produces.stream().map(mediaType -> mediaType.trim().substring(0, mediaType.indexOf("/"))).distinct().collect(Collectors.toList());
            this.setProducesSubTypes(subAttributeValues);
        }
    }

    public List<String> getProducesSubTypes() {
        return this.producesSubTypes;
    }

    public void setProducesSubTypes(List<String> producesSubTypes) {
        this.producesSubTypes = producesSubTypes;
    }

    public CorsHeaders getCorsHeaders() {
        return this.corsHeaders;
    }

    public void setCorsHeaders(CorsHeaders corsHeaders) {
        this.corsHeaders = corsHeaders;
    }

    public boolean isTransactionInfectable() {
        return this.transactionInfectable;
    }

    public void setTransactionInfectable(boolean transactionInfectable) {
        this.transactionInfectable = transactionInfectable;
    }

    public String getEntityBodyAttributeValue() {
        return this.entityBodyAttribute;
    }

    public void setEntityBodyAttributeValue(String entityBodyAttribute) {
        this.entityBodyAttribute = entityBodyAttribute;
    }

    public static HttpResource buildHttpResource(Resource resource, HttpService httpService) {
        HttpResource httpResource = new HttpResource(resource, httpService);
        Annotation resourceConfigAnnotation = HttpResource.getResourceConfigAnnotation(resource);
        if (resourceConfigAnnotation == null) {
            if (log.isDebugEnabled()) {
                log.debug("resourceConfig not specified in the Resource instance, using default sub path");
            }
            httpResource.setPath(resource.getName());
            httpResource.prepareAndValidateSignatureParams();
            return httpResource;
        }
        Struct resourceConfig = resourceConfigAnnotation.getValue();
        httpResource.setPath(resourceConfig.getStringField(PATH_FIELD));
        httpResource.setMethods(HttpResource.getAsStringList(resourceConfig.getArrayField(METHODS_FIELD)));
        httpResource.setConsumes(HttpResource.getAsStringList(resourceConfig.getArrayField(CONSUMES_FIELD)));
        httpResource.setProduces(HttpResource.getAsStringList(resourceConfig.getArrayField(PRODUCES_FIELD)));
        httpResource.setEntityBodyAttributeValue(resourceConfig.getStringField(BODY_FIELD));
        httpResource.setCorsHeaders(CorsHeaders.buildCorsHeaders(resourceConfig.getStructField(CORS_FIELD)));
        httpResource.setTransactionInfectable(resourceConfig.getBooleanField(TRANSACTION_INFECTABLE_FIELD));
        HttpResource.processResourceCors(httpResource, httpService);
        httpResource.prepareAndValidateSignatureParams();
        return httpResource;
    }

    protected static Annotation getResourceConfigAnnotation(Resource resource) {
        List annotationList = resource.getAnnotationList("ballerina.http", "ResourceConfig");
        if (annotationList == null) {
            return null;
        }
        if (annotationList.size() > 1) {
            throw new BallerinaException("multiple resource configuration annotations found in resource: " + resource.getServiceName() + "." + resource.getName());
        }
        return annotationList.isEmpty() ? null : (Annotation)annotationList.get(0);
    }

    private static List<String> getAsStringList(Value[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesList = new ArrayList<String>();
        for (Value val : values) {
            valuesList.add(val.getStringValue().trim());
        }
        return !valuesList.isEmpty() ? valuesList : null;
    }

    private static void processResourceCors(HttpResource resource, HttpService service) {
        CorsHeaders corsHeaders = resource.getCorsHeaders();
        if (!corsHeaders.isAvailable()) {
            resource.setCorsHeaders(service.getCorsHeaders());
            return;
        }
        if (corsHeaders.getAllowOrigins() == null) {
            corsHeaders.setAllowOrigins(Stream.of("*").collect(Collectors.toList()));
        }
        if (corsHeaders.getAllowMethods() != null) {
            return;
        }
        if (resource.getMethods() != null) {
            corsHeaders.setAllowMethods(resource.getMethods());
            return;
        }
        corsHeaders.setAllowMethods(DispatcherUtil.addAllMethods());
    }

    private void prepareAndValidateSignatureParams() {
        this.signatureParams = new SignatureParams(this, this.balResource.getParamDetails());
        this.signatureParams.validate();
    }
}

