/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.uri.DispatcherUtil;
import org.ballerinalang.net.uri.parser.DataElement;
import org.ballerinalang.net.uri.parser.DataReturnAgent;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class HttpResourceDataElement
implements DataElement<HttpResource, HTTPCarbonMessage> {
    private List<HttpResource> resource;
    private boolean isFirstTraverse = true;
    private boolean hasData = false;

    @Override
    public boolean hasData() {
        return this.hasData;
    }

    @Override
    public void setData(HttpResource newResource) {
        if (this.isFirstTraverse) {
            this.resource = new ArrayList<HttpResource>();
            this.resource.add(newResource);
            this.isFirstTraverse = false;
            this.hasData = true;
            return;
        }
        List<String> newMethods = newResource.getMethods();
        if (newMethods == null) {
            for (HttpResource previousResource : this.resource) {
                if (previousResource.getMethods() != null) continue;
                throw new BallerinaException("Two resources have the same addressable URI, " + previousResource.getName() + " and " + newResource.getName());
            }
            this.resource.add(newResource);
            this.hasData = true;
            return;
        }
        this.resource.forEach(r -> {
            for (String newMethod : newMethods) {
                if (!DispatcherUtil.isMatchingMethodExist(r, newMethod)) continue;
                throw new BallerinaException("Two resources have the same addressable URI, " + r.getName() + " and " + newResource.getName());
            }
        });
        this.resource.add(newResource);
        this.hasData = true;
    }

    @Override
    public boolean getData(HTTPCarbonMessage carbonMessage, DataReturnAgent<HttpResource> dataReturnAgent) {
        try {
            if (this.resource == null) {
                return false;
            }
            HttpResource resource = this.validateHTTPMethod(this.resource, carbonMessage);
            if (resource == null) {
                return false;
            }
            this.validateConsumes(resource, carbonMessage);
            this.validateProduces(resource, carbonMessage);
            dataReturnAgent.setData(resource);
            return true;
        }
        catch (BallerinaException e) {
            dataReturnAgent.setError(e);
            return false;
        }
    }

    private HttpResource validateHTTPMethod(List<HttpResource> resources, HTTPCarbonMessage carbonMessage) {
        HttpResource resource = null;
        boolean isOptionsRequest = false;
        String httpMethod = (String)carbonMessage.getProperty("HTTP_METHOD");
        for (HttpResource resourceInfo : resources) {
            if (!DispatcherUtil.isMatchingMethodExist(resourceInfo, httpMethod)) continue;
            resource = resourceInfo;
            break;
        }
        if (resource == null) {
            resource = this.tryMatchingToDefaultVerb(resources);
        }
        if (resource == null) {
            isOptionsRequest = this.setAllowHeadersIfOPTIONS(httpMethod, carbonMessage);
        }
        if (resource != null) {
            return resource;
        }
        if (!isOptionsRequest) {
            carbonMessage.setProperty("HTTP_STATUS_CODE", (Object)405);
            throw new BallerinaException("Method not allowed");
        }
        return null;
    }

    private HttpResource tryMatchingToDefaultVerb(List<HttpResource> resources) {
        for (HttpResource resourceInfo : resources) {
            if (resourceInfo.getMethods() != null) continue;
            return resourceInfo;
        }
        return null;
    }

    private boolean setAllowHeadersIfOPTIONS(String httpMethod, HTTPCarbonMessage cMsg) {
        if (httpMethod.equals("OPTIONS")) {
            cMsg.setHeader(HttpHeaderNames.ALLOW.toString(), this.getAllowHeaderValues(cMsg));
            return true;
        }
        return false;
    }

    private String getAllowHeaderValues(HTTPCarbonMessage cMsg) {
        List<String> methods = new ArrayList<String>();
        ArrayList<HttpResource> resourceInfos = new ArrayList<HttpResource>();
        for (HttpResource resourceInfo : this.resource) {
            if (resourceInfo.getMethods() != null) {
                methods.addAll(resourceInfo.getMethods());
            }
            resourceInfos.add(resourceInfo);
        }
        cMsg.setProperty("PREFLIGHT_RESOURCES", resourceInfos);
        methods = DispatcherUtil.validateAllowMethods(methods);
        return DispatcherUtil.concatValues(methods, false);
    }

    public HttpResource validateConsumes(HttpResource resource, HTTPCarbonMessage cMsg) {
        String contentMediaType = this.extractContentMediaType(cMsg.getHeader(HttpHeaderNames.CONTENT_TYPE.toString()));
        List<String> consumesList = resource.getConsumes();
        if (consumesList == null) {
            return resource;
        }
        contentMediaType = contentMediaType != null ? contentMediaType : "value";
        for (String consumeType : consumesList) {
            if (!contentMediaType.equals(consumeType.trim())) continue;
            return resource;
        }
        cMsg.setProperty("HTTP_STATUS_CODE", (Object)415);
        throw new BallerinaException();
    }

    private String extractContentMediaType(String header) {
        if (header == null) {
            return null;
        }
        if (header.contains(";")) {
            header = header.substring(0, header.indexOf(";")).trim();
        }
        return header;
    }

    public HttpResource validateProduces(HttpResource resource, HTTPCarbonMessage cMsg) {
        List<String> acceptMediaTypes = this.extractAcceptMediaTypes(cMsg.getHeader(HttpHeaderNames.ACCEPT.toString()));
        List<String> producesList = resource.getProduces();
        if (producesList == null || acceptMediaTypes == null) {
            return resource;
        }
        if (acceptMediaTypes.contains("*/*")) {
            return resource;
        }
        if (acceptMediaTypes.stream().anyMatch(mediaType -> mediaType.contains("/*"))) {
            List subTypeWildCardMediaTypes = acceptMediaTypes.stream().filter(mediaType -> mediaType.contains("/*")).map(mediaType -> mediaType.substring(0, mediaType.indexOf("/"))).collect(Collectors.toList());
            for (String token : resource.getProducesSubTypes()) {
                if (!subTypeWildCardMediaTypes.contains(token)) continue;
                return resource;
            }
        }
        List noWildCardMediaTypes = acceptMediaTypes.stream().filter(mediaType -> !mediaType.contains("/*")).collect(Collectors.toList());
        for (String produceType : producesList) {
            if (!noWildCardMediaTypes.contains(produceType)) continue;
            return resource;
        }
        cMsg.setProperty("HTTP_STATUS_CODE", (Object)406);
        throw new BallerinaException();
    }

    private List<String> extractAcceptMediaTypes(String header) {
        List<String> acceptMediaTypes = new ArrayList<String>();
        if (header == null) {
            return null;
        }
        if (header.contains(",")) {
            acceptMediaTypes = Arrays.stream(header.split(",")).map(mediaRange -> mediaRange.contains(";") ? mediaRange.substring(0, mediaRange.indexOf(";")) : mediaRange).map(String::trim).distinct().collect(Collectors.toList());
        } else if (header.contains(";")) {
            acceptMediaTypes.add(header.substring(0, header.indexOf(";")).trim());
        } else {
            acceptMediaTypes.add(header.trim());
        }
        return acceptMediaTypes;
    }
}

