/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.HashMap;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.net.http.CorsHeaderGenerator;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.uri.DispatcherUtil;
import org.ballerinalang.net.uri.URITemplateException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class HttpResourceDispatcher {
    public static HttpResource findResource(HttpService service, HTTPCarbonMessage inboundRequest) throws BallerinaConnectorException {
        String method = (String)inboundRequest.getProperty("HTTP_METHOD");
        String subPath = (String)inboundRequest.getProperty("SUB_PATH");
        subPath = HttpResourceDispatcher.sanitizeSubPath(subPath);
        HashMap<String, String> resourceArgumentValues = new HashMap<String, String>();
        try {
            HttpResource resource = service.getUriTemplate().matches(subPath, resourceArgumentValues, inboundRequest);
            if (resource != null) {
                inboundRequest.setProperty("RESOURCE_ARGS", resourceArgumentValues);
                inboundRequest.setProperty("RESOURCES_CORS", (Object)resource.getCorsHeaders());
                return resource;
            }
            if (!method.equals("OPTIONS")) {
                inboundRequest.setProperty("HTTP_STATUS_CODE", (Object)404);
                throw new BallerinaConnectorException("no matching resource found for path : " + inboundRequest.getProperty("TO") + " , method : " + method);
            }
            HttpResourceDispatcher.handleOptionsRequest(inboundRequest, service);
            return null;
        }
        catch (URITemplateException e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
    }

    private static String sanitizeSubPath(String subPath) {
        if ("/".equals(subPath)) {
            return subPath;
        }
        if (!subPath.startsWith("/")) {
            subPath = "/" + subPath;
        }
        subPath = subPath.endsWith("/") ? subPath.substring(0, subPath.length() - 1) : subPath;
        return subPath;
    }

    private static void handleOptionsRequest(HTTPCarbonMessage cMsg, HttpService service) throws URITemplateException {
        HTTPCarbonMessage response = HttpUtil.createHttpCarbonMessage(false);
        if (cMsg.getHeader(HttpHeaderNames.ALLOW.toString()) != null) {
            response.setHeader(HttpHeaderNames.ALLOW.toString(), cMsg.getHeader(HttpHeaderNames.ALLOW.toString()));
        } else if (service.getBasePath().equals(cMsg.getProperty("TO")) && !service.getAllAllowedMethods().isEmpty()) {
            response.setHeader(HttpHeaderNames.ALLOW.toString(), DispatcherUtil.concatValues(service.getAllAllowedMethods(), false));
        } else {
            cMsg.setProperty("HTTP_STATUS_CODE", (Object)404);
            throw new BallerinaConnectorException("no matching resource found for path : " + cMsg.getProperty("TO") + " , method : " + "OPTIONS");
        }
        CorsHeaderGenerator.process(cMsg, response, false);
        response.setProperty("HTTP_STATUS_CODE", (Object)200);
        response.addHttpContent((HttpContent)new DefaultLastHttpContent());
        HttpUtil.sendOutboundResponse(cMsg, response);
    }
}

