/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.connector.api.Annotation;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.net.http.CorsHeaders;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpResourceDataElement;
import org.ballerinalang.net.http.HttpResourceElementFactory;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.uri.DispatcherUtil;
import org.ballerinalang.net.uri.URITemplate;
import org.ballerinalang.net.uri.URITemplateException;
import org.ballerinalang.net.uri.parser.Literal;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class HttpService
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(HttpService.class);
    protected static final String BASE_PATH_FIELD = "basePath";
    private static final String COMPRESSION_FIELD = "compression";
    private static final String CORS_FIELD = "cors";
    private static final String VERSIONING_FIELD = "versioning";
    protected static final String WEBSOCKET_UPGRADE_FIELD = "webSocketUpgrade";
    private Service balService;
    private List<HttpResource> resources;
    private List<Resource> upgradeToWebSocketResources;
    private List<String> allAllowedMethods;
    private String basePath;
    private CorsHeaders corsHeaders;
    private URITemplate<HttpResource, HTTPCarbonMessage> uriTemplate;
    private boolean keepAlive = true;
    private String compression = "AUTO";

    public Service getBallerinaService() {
        return this.balService;
    }

    protected HttpService(Service service) {
        this.balService = service;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getName() {
        return this.balService.getName();
    }

    public String getPackage() {
        return this.balService.getPackage();
    }

    public Service getBalService() {
        return this.balService;
    }

    public List<HttpResource> getResources() {
        return this.resources;
    }

    public void setResources(List<HttpResource> resources) {
        this.resources = resources;
    }

    public List<String> getAllAllowedMethods() {
        return this.allAllowedMethods;
    }

    public void setAllAllowedMethods(List<String> allAllowMethods) {
        this.allAllowedMethods = allAllowMethods;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        if (basePath == null || basePath.trim().isEmpty()) {
            this.basePath = "/".concat(this.getName());
        } else {
            String sanitizedPath = this.sanitizeBasePath(basePath);
            this.basePath = this.urlDecode(sanitizedPath);
        }
    }

    public CorsHeaders getCorsHeaders() {
        return this.corsHeaders;
    }

    public void setCorsHeaders(CorsHeaders corsHeaders) {
        this.corsHeaders = corsHeaders;
        if (this.corsHeaders == null || !this.corsHeaders.isAvailable()) {
            return;
        }
        if (this.corsHeaders.getAllowOrigins() == null) {
            this.corsHeaders.setAllowOrigins(Stream.of("*").collect(Collectors.toList()));
        }
        if (this.corsHeaders.getAllowMethods() == null) {
            this.corsHeaders.setAllowMethods(Stream.of("*").collect(Collectors.toList()));
        }
    }

    public List<Resource> getUpgradeToWebSocketResources() {
        return this.upgradeToWebSocketResources;
    }

    public void setUpgradeToWebSocketResources(List<Resource> upgradeToWebSocketResources) {
        this.upgradeToWebSocketResources = upgradeToWebSocketResources;
    }

    public URITemplate<HttpResource, HTTPCarbonMessage> getUriTemplate() throws URITemplateException {
        if (this.uriTemplate == null) {
            this.uriTemplate = new URITemplate<HttpResource, HTTPCarbonMessage>(new Literal<HttpResource, HTTPCarbonMessage>(new HttpResourceDataElement(), "/"));
        }
        return this.uriTemplate;
    }

    public static List<HttpService> buildHttpService(Service service) {
        ArrayList<HttpService> serviceList = new ArrayList<HttpService>();
        ArrayList<String> basePathList = new ArrayList<String>();
        HttpService httpService = new HttpService(service);
        Annotation serviceConfigAnnotation = HttpService.getHttpServiceConfigAnnotation(service);
        if (serviceConfigAnnotation == null) {
            log.debug("serviceConfig not specified in the Service instance, using default base path");
            basePathList.add("/".concat(httpService.getName()));
        } else {
            Struct serviceConfig = serviceConfigAnnotation.getValue();
            httpService.setCompression(serviceConfig.getRefField(COMPRESSION_FIELD).getStringValue());
            httpService.setCorsHeaders(CorsHeaders.buildCorsHeaders(serviceConfig.getStructField(CORS_FIELD)));
            String basePath = serviceConfig.getStringField(BASE_PATH_FIELD);
            if (basePath.contains("{version}")) {
                HttpService.prepareBasePathList(serviceConfig.getStructField(VERSIONING_FIELD), serviceConfig.getStringField(BASE_PATH_FIELD), basePathList, httpService.getBallerinaService().getPackageVersion());
            } else {
                basePathList.add(basePath);
            }
        }
        ArrayList<HttpResource> httpResources = new ArrayList<HttpResource>();
        ArrayList<Resource> upgradeToWebSocketResources = new ArrayList<Resource>();
        for (Resource resource : httpService.getBallerinaService().getResources()) {
            Annotation resourceConfigAnnotation = HttpUtil.getResourceConfigAnnotation(resource, "ballerina.http");
            if (resourceConfigAnnotation != null && resourceConfigAnnotation.getValue().getStructField(WEBSOCKET_UPGRADE_FIELD) != null) {
                upgradeToWebSocketResources.add(resource);
                continue;
            }
            HttpResource httpResource = HttpResource.buildHttpResource(resource, httpService);
            try {
                httpService.getUriTemplate().parse(httpResource.getPath(), httpResource, new HttpResourceElementFactory());
            }
            catch (UnsupportedEncodingException | URITemplateException e) {
                throw new BallerinaConnectorException(e.getMessage());
            }
            httpResources.add(httpResource);
        }
        httpService.setResources(httpResources);
        httpService.setUpgradeToWebSocketResources(upgradeToWebSocketResources);
        httpService.setAllAllowedMethods(DispatcherUtil.getAllResourceMethods(httpService));
        if (basePathList.size() == 1) {
            httpService.setBasePath((String)basePathList.get(0));
            serviceList.add(httpService);
            return serviceList;
        }
        for (String basePath : basePathList) {
            HttpService tempHttpService;
            try {
                tempHttpService = (HttpService)httpService.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new BallerinaConnectorException("Service registration failed");
            }
            tempHttpService.setBasePath(basePath);
            serviceList.add(tempHttpService);
        }
        return serviceList;
    }

    private static void prepareBasePathList(Struct versioningConfig, String basePath, List<String> basePathList, String packageVersion) {
        String patternAnnotValue = "v.{major}.{minor}";
        Boolean allowNoVersionAnnotValue = false;
        Boolean matchMajorVersionAnnotValue = false;
        if (versioningConfig != null) {
            patternAnnotValue = versioningConfig.getStringField("pattern");
            allowNoVersionAnnotValue = versioningConfig.getBooleanField("allowNoVersion");
            matchMajorVersionAnnotValue = versioningConfig.getBooleanField("matchMajorVersion");
        }
        patternAnnotValue = patternAnnotValue.toLowerCase();
        basePathList.add(HttpService.replaceServiceVersion(basePath, packageVersion, patternAnnotValue));
        if (allowNoVersionAnnotValue.booleanValue()) {
            basePathList.add(basePath.replace("{version}", "").replace("//", "/"));
        }
        if (matchMajorVersionAnnotValue.booleanValue()) {
            String patternWithMajor = patternAnnotValue.replace("{minor}", "");
            patternWithMajor = patternWithMajor.endsWith(".") ? patternWithMajor.substring(0, patternWithMajor.length() - 1) : patternWithMajor;
            basePathList.add(HttpService.replaceServiceVersion(basePath, packageVersion, patternWithMajor));
        }
    }

    private static String replaceServiceVersion(String basePath, String version, String pattern) {
        String minorVersion;
        pattern = pattern.toLowerCase();
        String[] versionElements = version.split("\\.");
        String majorVersion = versionElements[0];
        String string = minorVersion = versionElements.length > 1 ? versionElements[1] : "";
        if (pattern.contains("{major}") || pattern.contains("{minor}")) {
            String patternReplaced = pattern.replace("{major}", majorVersion);
            String result = patternReplaced.replace("{minor}", minorVersion);
            return basePath.replace("{version}", result);
        }
        throw new BallerinaConnectorException("Invalid versioning pattern: expect \"{major},{minor}\" elements");
    }

    private static Annotation getHttpServiceConfigAnnotation(Service service) {
        return HttpService.getServiceConfigAnnotation(service, "ballerina.http", "ServiceConfig");
    }

    protected static Annotation getServiceConfigAnnotation(Service service, String packagePath, String annotationName) {
        List annotationList = service.getAnnotationList(packagePath, annotationName);
        if (annotationList == null || annotationList.isEmpty()) {
            return null;
        }
        if (annotationList.size() > 1) {
            throw new BallerinaException("multiple service configuration annotations found in service: " + service.getName());
        }
        return (Annotation)annotationList.get(0);
    }

    private String sanitizeBasePath(String basePath) {
        if (!(basePath = basePath.trim()).startsWith("/")) {
            basePath = "/".concat(basePath);
        }
        if (basePath.endsWith("/") && basePath.length() != 1) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return basePath;
    }

    private String urlDecode(String basePath) {
        try {
            basePath = URLDecoder.decode(basePath, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
        return basePath;
    }
}

