/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.connector.api.AnnAttrValue;
import org.ballerinalang.connector.api.Annotation;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.ConnectorUtils;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.mime.util.MultipartDecoder;
import org.ballerinalang.model.types.BServiceType;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.http.CorsHeaderGenerator;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.caching.RequestCacheControlStruct;
import org.ballerinalang.net.http.caching.ResponseCacheControlStruct;
import org.ballerinalang.net.http.session.Session;
import org.ballerinalang.services.ErrorHandlerUtils;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.observability.ObservabilityUtils;
import org.ballerinalang.util.observability.ObserverContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.config.ChunkConfig;
import org.wso2.transport.http.netty.config.ForwardedExtensionConfig;
import org.wso2.transport.http.netty.config.KeepAliveConfig;
import org.wso2.transport.http.netty.config.ListenerConfiguration;
import org.wso2.transport.http.netty.config.Parameter;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.HttpWsConnectorFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpWsConnectorFactory;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

public class HttpUtil {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final String METHOD_ACCESSED = "isMethodAccessed";
    private static final String IO_EXCEPTION_OCCURED = "I/O exception occurred";
    private static final String CHUNKING_CONFIG = "chunking_config";

    public static BValue[] getProperty(Context context, boolean isRequest) {
        String propertyName;
        BStruct httpMessageStruct = (BStruct)context.getRefArgument(0);
        HTTPCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(httpMessageStruct, HttpUtil.createHttpCarbonMessage(isRequest));
        Object propertyValue = httpCarbonMessage.getProperty(propertyName = context.getStringArgument(0));
        if (propertyValue == null) {
            return new BValue[0];
        }
        if (propertyValue instanceof String) {
            return new BValue[]{new BString((String)propertyValue)};
        }
        throw new BallerinaException("Property value is of unknown type : " + propertyValue.getClass().getName());
    }

    public static void setProperty(Context context, boolean isRequest) {
        BStruct httpMessageStruct = (BStruct)context.getRefArgument(0);
        String propertyName = context.getStringArgument(0);
        String propertyValue = context.getStringArgument(1);
        if (propertyName != null && propertyValue != null) {
            HTTPCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(httpMessageStruct, HttpUtil.createHttpCarbonMessage(isRequest));
            httpCarbonMessage.setProperty(propertyName, (Object)propertyValue);
        }
    }

    public static void setEntity(Context context, boolean isRequest) {
        BStruct httpMessageStruct = (BStruct)context.getRefArgument(0);
        HTTPCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(httpMessageStruct, HttpUtil.createHttpCarbonMessage(isRequest));
        BStruct entity = (BStruct)context.getRefArgument(1);
        String contentType = MimeUtil.getContentTypeWithParameters((BStruct)entity);
        if (EntityBodyHandler.checkEntityBodyAvailability((BStruct)entity)) {
            httpCarbonMessage.waitAndReleaseAllEntities();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            HeaderUtil.setHeaderToEntity((BStruct)entity, (String)HttpHeaderNames.CONTENT_TYPE.toString(), (String)contentType);
        }
        httpMessageStruct.addNativeData("message_entity", (Object)entity);
        httpMessageStruct.addNativeData("is_byte_channel_set", (Object)EntityBodyHandler.checkEntityBodyAvailability((BStruct)entity));
    }

    public static BValue[] getEntity(Context context, boolean isRequest, boolean isEntityBodyRequired) {
        try {
            BStruct httpMessageStruct = (BStruct)context.getRefArgument(0);
            BStruct entity = (BStruct)httpMessageStruct.getNativeData("message_entity");
            boolean isByteChannelAlreadySet = false;
            if (httpMessageStruct.getNativeData("is_byte_channel_set") != null) {
                isByteChannelAlreadySet = (Boolean)httpMessageStruct.getNativeData("is_byte_channel_set");
            }
            if (entity != null && isEntityBodyRequired && !isByteChannelAlreadySet) {
                HttpUtil.populateEntityBody(context, httpMessageStruct, entity, isRequest);
            }
            if (entity == null) {
                entity = EntityBodyHandler.createNewEntity((Context)context, (BStruct)httpMessageStruct);
            }
            return new BValue[]{entity};
        }
        catch (Throwable throwable) {
            return new BValue[]{MimeUtil.createEntityError((Context)context, (String)("Error occurred during entity construction: " + throwable.getMessage()))};
        }
    }

    public static void populateEntityBody(Context context, BStruct httpMessageStruct, BStruct entity, boolean isRequest) {
        HTTPCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(httpMessageStruct, HttpUtil.createHttpCarbonMessage(isRequest));
        HttpMessageDataStreamer httpMessageDataStreamer = new HttpMessageDataStreamer(httpCarbonMessage);
        String contentType = httpCarbonMessage.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
        if (MimeUtil.isNotNullAndEmpty((String)contentType) && contentType.startsWith("multipart/") && context != null) {
            MultipartDecoder.parseBody((Context)context, (BStruct)entity, (String)contentType, (InputStream)httpMessageDataStreamer.getInputStream());
        } else {
            int contentLength = -1;
            String lengthStr = httpCarbonMessage.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
            try {
                int n = contentLength = lengthStr != null ? Integer.parseInt(lengthStr) : contentLength;
                if (contentLength == -1) {
                    contentLength = httpCarbonMessage.countMessageLengthTill(0x200000);
                }
            }
            catch (NumberFormatException e) {
                throw new BallerinaException("Invalid content length");
            }
            EntityBodyHandler.setDiscreteMediaTypeBodyContent((BStruct)entity, (InputStream)httpMessageDataStreamer.getInputStream(), (int)contentLength);
        }
        httpMessageStruct.addNativeData("message_entity", (Object)entity);
        httpMessageStruct.addNativeData("is_byte_channel_set", (Object)true);
    }

    public static void closeMessageOutputStream(OutputStream messageOutputStream) {
        try {
            if (messageOutputStream != null) {
                messageOutputStream.close();
            }
        }
        catch (IOException e) {
            log.error("Couldn't close message output stream", (Throwable)e);
        }
    }

    public static void prepareOutboundResponse(Context context, HTTPCarbonMessage inboundRequestMsg, HTTPCarbonMessage outboundResponseMsg, BStruct outboundResponseStruct) {
        HttpUtil.checkEntityAvailability(context, outboundResponseStruct);
        HttpUtil.addHTTPSessionAndCorsHeaders(context, inboundRequestMsg, outboundResponseMsg);
        HttpUtil.enrichOutboundMessage(outboundResponseMsg, outboundResponseStruct);
        HttpUtil.setCompressionHeaders(context, inboundRequestMsg, outboundResponseMsg);
        HttpUtil.setChunkingHeader(context, outboundResponseMsg);
    }

    public static BStruct createSessionStruct(Context context, Session session) {
        BStruct sessionStruct = ConnectorUtils.createAndGetStruct((Context)context, (String)"ballerina.http", (String)"Session");
        sessionStruct.addNativeData("http_session", (Object)session);
        return sessionStruct;
    }

    public static String getSessionID(String cookieHeader) {
        return Arrays.stream(cookieHeader.split(";")).filter(cookie -> cookie.trim().startsWith("BSESSIONID=")).findFirst().get().trim().substring("BSESSIONID=".length());
    }

    public static void addHTTPSessionAndCorsHeaders(Context context, HTTPCarbonMessage requestMsg, HTTPCarbonMessage responseMsg) {
        if (requestMsg.getHeader(HttpHeaderNames.ORIGIN.toString()) != null) {
            CorsHeaderGenerator.process(requestMsg, responseMsg, true);
        }
    }

    public static HttpResponseFuture sendOutboundResponse(HTTPCarbonMessage requestMsg, HTTPCarbonMessage responseMsg) {
        HttpResponseFuture responseFuture;
        try {
            responseFuture = requestMsg.respond(responseMsg);
        }
        catch (ServerConnectorException e) {
            throw new BallerinaConnectorException("Error occurred during response", (Throwable)e);
        }
        return responseFuture;
    }

    public static HttpResponseFuture pushResponse(HTTPCarbonMessage requestMsg, HTTPCarbonMessage pushResponse, Http2PushPromise pushPromise) {
        HttpResponseFuture responseFuture;
        try {
            responseFuture = requestMsg.pushResponse(pushResponse, pushPromise);
        }
        catch (ServerConnectorException e) {
            throw new BallerinaConnectorException("Error occurred while sending a server push message", (Throwable)e);
        }
        return responseFuture;
    }

    public static HttpResponseFuture pushPromise(HTTPCarbonMessage requestMsg, Http2PushPromise pushPromise) {
        HttpResponseFuture responseFuture;
        try {
            responseFuture = requestMsg.pushPromise(pushPromise);
        }
        catch (ServerConnectorException e) {
            throw new BallerinaConnectorException("Error occurred during response", (Throwable)e);
        }
        return responseFuture;
    }

    public static void handleFailure(HTTPCarbonMessage requestMessage, BallerinaConnectorException ex) {
        Object carbonStatusCode = requestMessage.getProperty("HTTP_STATUS_CODE");
        int statusCode = carbonStatusCode == null ? 500 : Integer.parseInt(carbonStatusCode.toString());
        String errorMsg = ex.getMessage();
        log.error(errorMsg, (Throwable)ex);
        HttpUtil.sendOutboundResponse(requestMessage, HttpUtil.createErrorMessage(errorMsg, statusCode));
    }

    public static void handleFailure(HTTPCarbonMessage requestMessage, BStruct error) {
        Object carbonStatusCode = requestMessage.getProperty("HTTP_STATUS_CODE");
        int statusCode = carbonStatusCode == null ? 500 : Integer.parseInt(carbonStatusCode.toString());
        String errorMsg = error.getStringField(0);
        log.error(errorMsg);
        ErrorHandlerUtils.printError((String)("error: " + BLangVMErrors.getPrintableStackTrace((BStruct)error)));
        HttpUtil.sendOutboundResponse(requestMessage, HttpUtil.createErrorMessage(errorMsg, statusCode));
    }

    public static HTTPCarbonMessage createErrorMessage(String payload, int statusCode) {
        HTTPCarbonMessage response = HttpUtil.createHttpCarbonMessage(false);
        response.waitAndReleaseAllEntities();
        if (payload != null) {
            payload = HttpUtil.lowerCaseTheFirstLetter(payload);
            response.addHttpContent((HttpContent)new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])payload.getBytes())));
        } else {
            response.addHttpContent((HttpContent)new DefaultLastHttpContent());
        }
        HttpUtil.setHttpStatusCodes(statusCode, response);
        return response;
    }

    private static String lowerCaseTheFirstLetter(String payload) {
        if (!payload.isEmpty()) {
            char[] characters = payload.toCharArray();
            characters[0] = Character.toLowerCase(characters[0]);
            payload = new String(characters);
        }
        return payload;
    }

    private static void setHttpStatusCodes(int statusCode, HTTPCarbonMessage response) {
        HttpHeaders httpHeaders = response.getHeaders();
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        response.setProperty("HTTP_STATUS_CODE", (Object)statusCode);
    }

    public static BStruct getHttpConnectorError(Context context, Throwable throwable) {
        PackageInfo httpPackageInfo = context.getProgramFile().getPackageInfo("ballerina.http");
        StructInfo errorStructInfo = httpPackageInfo.getStructInfo("HttpConnectorError");
        BStruct httpConnectorError = new BStruct(errorStructInfo.getType());
        if (throwable.getMessage() == null) {
            httpConnectorError.setStringField(0, IO_EXCEPTION_OCCURED);
        } else {
            httpConnectorError.setStringField(0, throwable.getMessage());
        }
        return httpConnectorError;
    }

    public static HTTPCarbonMessage getCarbonMsg(BStruct struct, HTTPCarbonMessage defaultMsg) {
        HTTPCarbonMessage httpCarbonMessage = (HTTPCarbonMessage)struct.getNativeData("transport_message");
        if (httpCarbonMessage != null) {
            return httpCarbonMessage;
        }
        HttpUtil.addCarbonMsg(struct, defaultMsg);
        return defaultMsg;
    }

    public static Http2PushPromise getPushPromise(BStruct pushPromiseStruct, Http2PushPromise defaultPushPromise) {
        Http2PushPromise pushPromise = (Http2PushPromise)pushPromiseStruct.getNativeData("transport_push_promise");
        if (pushPromise != null) {
            return pushPromise;
        }
        pushPromiseStruct.addNativeData("transport_push_promise", (Object)defaultPushPromise);
        return defaultPushPromise;
    }

    public static void populatePushPromiseStruct(BStruct pushPromiseStruct, Http2PushPromise pushPromise) {
        pushPromiseStruct.addNativeData("transport_push_promise", (Object)pushPromise);
        pushPromiseStruct.setStringField(0, pushPromise.getPath());
        pushPromiseStruct.setStringField(1, pushPromise.getMethod());
    }

    public static Http2PushPromise createHttpPushPromise(BStruct struct) {
        String path;
        String method = struct.getStringField(1);
        if (method == null || method.isEmpty()) {
            method = "GET";
        }
        if ((path = struct.getStringField(0)) == null || path.isEmpty()) {
            path = "/";
        }
        return new Http2PushPromise(method, path);
    }

    public static void addCarbonMsg(BStruct struct, HTTPCarbonMessage httpCarbonMessage) {
        struct.addNativeData("transport_message", (Object)httpCarbonMessage);
    }

    public static void populateInboundRequest(BStruct inboundRequestStruct, BStruct entity, BStruct mediaType, HTTPCarbonMessage inboundRequestMsg, RequestCacheControlStruct requestCacheControl) {
        inboundRequestStruct.addNativeData("transport_message", (Object)inboundRequestMsg);
        inboundRequestStruct.addNativeData("Request", (Object)true);
        HttpUtil.enrichWithInboundRequestInfo(inboundRequestStruct, inboundRequestMsg);
        HttpUtil.enrichWithInboundRequestHeaders(inboundRequestStruct, inboundRequestMsg);
        HttpUtil.populateEntity(entity, mediaType, inboundRequestMsg);
        inboundRequestStruct.addNativeData("message_entity", (Object)entity);
        inboundRequestStruct.addNativeData("is_byte_channel_set", (Object)false);
        if (inboundRequestMsg.getHeader(HttpHeaderNames.CACHE_CONTROL.toString()) != null) {
            requestCacheControl.populateStruct(inboundRequestMsg.getHeader(HttpHeaderNames.CACHE_CONTROL.toString()));
        }
        inboundRequestStruct.setRefField(0, (BRefType)requestCacheControl.getStruct());
    }

    private static void enrichWithInboundRequestHeaders(BStruct inboundRequestStruct, HTTPCarbonMessage inboundRequestMsg) {
        if (inboundRequestMsg.getHeader(HttpHeaderNames.USER_AGENT.toString()) != null) {
            inboundRequestStruct.setStringField(3, inboundRequestMsg.getHeader(HttpHeaderNames.USER_AGENT.toString()));
            inboundRequestMsg.removeHeader(HttpHeaderNames.USER_AGENT.toString());
        }
    }

    private static void enrichWithInboundRequestInfo(BStruct inboundRequestStruct, HTTPCarbonMessage inboundRequestMsg) {
        inboundRequestStruct.setStringField(0, (String)inboundRequestMsg.getProperty("REQUEST_URL"));
        inboundRequestStruct.setStringField(1, (String)inboundRequestMsg.getProperty("HTTP_METHOD"));
        inboundRequestStruct.setStringField(2, (String)inboundRequestMsg.getProperty("HTTP_VERSION"));
        Map resourceArgValues = (Map)inboundRequestMsg.getProperty("RESOURCE_ARGS");
        if (resourceArgValues != null) {
            inboundRequestStruct.setStringField(4, (String)resourceArgValues.get("EXTRA_PATH_INFO"));
        }
    }

    public static void enrichConnectionInfo(BStruct connection, HTTPCarbonMessage inboundMsg) {
        connection.addNativeData("transport_message", (Object)inboundMsg);
    }

    public static void enrichServiceEndpointInfo(BStruct serviceEndpoint, HTTPCarbonMessage inboundMsg, HttpResource httpResource) {
        BStruct remote = BLangConnectorSPIUtil.createBStruct((ProgramFile)httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"Remote", (Object[])new Object[0]);
        BStruct local = BLangConnectorSPIUtil.createBStruct((ProgramFile)httpResource.getBalResource().getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"Local", (Object[])new Object[0]);
        Object remoteSocketAddress = inboundMsg.getProperty("REMOTE_ADDRESS");
        if (remoteSocketAddress != null && remoteSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteSocketAddress;
            String remoteHost = inetSocketAddress.getHostName();
            long remotePort = inetSocketAddress.getPort();
            remote.setStringField(0, remoteHost);
            remote.setIntField(0, remotePort);
        }
        serviceEndpoint.setRefField(2, (BRefType)remote);
        Object localSocketAddress = inboundMsg.getProperty("LOCAL_ADDRESS");
        if (localSocketAddress != null && localSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)localSocketAddress;
            String localHost = inetSocketAddress.getHostName();
            long localPort = inetSocketAddress.getPort();
            local.setStringField(0, localHost);
            local.setIntField(0, localPort);
        }
        serviceEndpoint.setRefField(3, (BRefType)local);
        serviceEndpoint.setStringField(0, (String)inboundMsg.getProperty("PROTOCOL"));
    }

    public static void populateInboundResponse(BStruct inboundResponse, BStruct entity, BStruct mediaType, ResponseCacheControlStruct responseCacheControl, HTTPCarbonMessage inboundResponseMsg) {
        inboundResponse.addNativeData("transport_message", (Object)inboundResponseMsg);
        int statusCode = (Integer)inboundResponseMsg.getProperty("HTTP_STATUS_CODE");
        inboundResponse.setIntField(0, (long)statusCode);
        inboundResponse.setStringField(0, HttpResponseStatus.valueOf((int)statusCode).reasonPhrase());
        if (inboundResponseMsg.getHeader(HttpHeaderNames.SERVER.toString()) != null) {
            inboundResponse.setStringField(1, inboundResponseMsg.getHeader(HttpHeaderNames.SERVER.toString()));
            inboundResponseMsg.removeHeader(HttpHeaderNames.SERVER.toString());
        }
        if (inboundResponseMsg.getHeader(HttpHeaderNames.CACHE_CONTROL.toString()) != null) {
            responseCacheControl.populateStruct(inboundResponseMsg.getHeader(HttpHeaderNames.CACHE_CONTROL.toString()));
        }
        inboundResponse.setRefField(0, (BRefType)responseCacheControl.getStruct());
        HttpUtil.populateEntity(entity, mediaType, inboundResponseMsg);
        inboundResponse.addNativeData("message_entity", (Object)entity);
        inboundResponse.addNativeData("is_byte_channel_set", (Object)false);
    }

    private static void populateEntity(BStruct entity, BStruct mediaType, HTTPCarbonMessage cMsg) {
        String contentType = cMsg.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
        MimeUtil.setContentType((BStruct)mediaType, (BStruct)entity, (String)contentType);
        int contentLength = -1;
        String lengthStr = cMsg.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        try {
            contentLength = lengthStr != null ? Integer.parseInt(lengthStr) : contentLength;
            MimeUtil.setContentLength((BStruct)entity, (int)contentLength);
        }
        catch (NumberFormatException e) {
            throw new BallerinaException("Invalid content length");
        }
        entity.addNativeData("entity_headers", (Object)cMsg.getHeaders());
    }

    public static void enrichOutboundMessage(HTTPCarbonMessage outboundMsg, BStruct outboundStruct) {
        HttpUtil.setHeadersToTransportMessage(outboundMsg, outboundStruct);
        HttpUtil.setPropertiesToTransportMessage(outboundMsg, outboundStruct);
    }

    private static void setHeadersToTransportMessage(HTTPCarbonMessage outboundMsg, BStruct struct) {
        HttpHeaders httpHeaders;
        BStruct entityStruct = (BStruct)struct.getNativeData("message_entity");
        HttpHeaders transportHeaders = outboundMsg.getHeaders();
        if (HttpUtil.isRequestStruct(struct) || HttpUtil.isResponseStruct(struct)) {
            HttpUtil.addRemovedPropertiesBackToHeadersMap(struct, transportHeaders);
        }
        if ((httpHeaders = (HttpHeaders)entityStruct.getNativeData("entity_headers")) != transportHeaders && httpHeaders != null) {
            transportHeaders.add(httpHeaders);
        }
    }

    private static boolean isRequestStruct(BStruct struct) {
        return struct.getType().getName().equals("Request");
    }

    private static boolean isResponseStruct(BStruct struct) {
        return struct.getType().getName().equals("Response");
    }

    private static void addRemovedPropertiesBackToHeadersMap(BStruct struct, HttpHeaders transportHeaders) {
        if (HttpUtil.isRequestStruct(struct)) {
            if (struct.getStringField(3) != null && !struct.getStringField(3).isEmpty()) {
                transportHeaders.set(HttpHeaderNames.USER_AGENT.toString(), (Object)struct.getStringField(3));
            }
        } else if (struct.getStringField(1) != null && !struct.getStringField(1).isEmpty()) {
            transportHeaders.set(HttpHeaderNames.SERVER.toString(), (Object)struct.getStringField(1));
        }
    }

    private static void setPropertiesToTransportMessage(HTTPCarbonMessage outboundResponseMsg, BStruct struct) {
        if (HttpUtil.isResponseStruct(struct)) {
            if (struct.getIntField(0) != 0L) {
                outboundResponseMsg.setProperty("HTTP_STATUS_CODE", (Object)HttpUtil.getIntValue(struct.getIntField(0)));
            }
            if (struct.getStringField(0) != null && !struct.getStringField(0).isEmpty()) {
                outboundResponseMsg.setProperty("HTTP_REASON_PHRASE", (Object)struct.getStringField(0));
            }
        }
    }

    public static void checkEntityAvailability(Context context, BStruct struct) {
        BStruct entity = (BStruct)struct.getNativeData("message_entity");
        if (entity == null) {
            EntityBodyHandler.createNewEntity((Context)context, (BStruct)struct);
        }
    }

    public static boolean isEntityDataSourceAvailble(BStruct struct) {
        return struct.getNativeData("message_entity") != null && EntityBodyHandler.getMessageDataSource((BStruct)((BStruct)struct.getNativeData("message_entity"))) != null;
    }

    private static void setCompressionHeaders(Context context, HTTPCarbonMessage requestMsg, HTTPCarbonMessage outboundResponseMsg) {
        Service serviceInstance = BLangConnectorSPIUtil.getService((ProgramFile)context.getProgramFile(), (BServiceType)context.getServiceInfo().getType());
        Annotation configAnnot = HttpUtil.getServiceConfigAnnotation(serviceInstance, "ballerina.http");
        if (configAnnot == null) {
            return;
        }
        String contentEncoding = outboundResponseMsg.getHeaders().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        if (contentEncoding != null) {
            return;
        }
        String compressionValue = configAnnot.getValue().getRefField("compression").getStringValue();
        String acceptEncodingValue = requestMsg.getHeaders().get((CharSequence)HttpHeaderNames.ACCEPT_ENCODING);
        if ("ALWAYS".equalsIgnoreCase(compressionValue)) {
            if (acceptEncodingValue == null || "identity".equals(acceptEncodingValue)) {
                outboundResponseMsg.getHeaders().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)"gzip");
            }
        } else if ("NEVER".equalsIgnoreCase(compressionValue)) {
            outboundResponseMsg.getHeaders().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)"identity");
        }
    }

    public static String getListenerInterface(String host, int port) {
        host = host != null ? host : "0.0.0.0";
        return host + ":" + port;
    }

    public static ChunkConfig getChunkConfig(String chunkConfig) {
        switch (chunkConfig) {
            case "AUTO": {
                return ChunkConfig.AUTO;
            }
            case "ALWAYS": {
                return ChunkConfig.ALWAYS;
            }
            case "NEVER": {
                return ChunkConfig.NEVER;
            }
        }
        throw new BallerinaConnectorException("Invalid configuration found for Transfer-Encoding: " + chunkConfig);
    }

    public static KeepAliveConfig getKeepAliveConfig(String keepAliveConfig) {
        switch (keepAliveConfig) {
            case "AUTO": {
                return KeepAliveConfig.AUTO;
            }
            case "ALWAYS": {
                return KeepAliveConfig.ALWAYS;
            }
            case "NEVER": {
                return KeepAliveConfig.NEVER;
            }
        }
        throw new BallerinaConnectorException("Invalid configuration found for Keep-Alive: " + keepAliveConfig);
    }

    public static ForwardedExtensionConfig getForwardedExtensionConfig(String forwarded) {
        ForwardedExtensionConfig forwardedConfig;
        if ("enable".equalsIgnoreCase(forwarded)) {
            forwardedConfig = ForwardedExtensionConfig.ENABLE;
        } else if ("transition".equalsIgnoreCase(forwarded)) {
            forwardedConfig = ForwardedExtensionConfig.TRANSITION;
        } else if ("disable".equalsIgnoreCase(forwarded)) {
            forwardedConfig = ForwardedExtensionConfig.DISABLE;
        } else {
            throw new BallerinaConnectorException("Invalid configuration found for Forwarded : " + forwarded);
        }
        return forwardedConfig;
    }

    private static void extractHttpsConfig(Annotation configInfo, Set<ListenerConfiguration> listenerConfSet) {
        AnnAttrValue httpsPortAttrVal = configInfo.getAnnAttrValue("httpsPort") == null ? configInfo.getAnnAttrValue("wssPort") : configInfo.getAnnAttrValue("httpsPort");
        AnnAttrValue keyStoreFileAttrVal = configInfo.getAnnAttrValue("keyStoreFile");
        AnnAttrValue keyStorePasswordAttrVal = configInfo.getAnnAttrValue("keyStorePassword");
        AnnAttrValue certPasswordAttrVal = configInfo.getAnnAttrValue("certPassword");
        AnnAttrValue trustStoreFileAttrVal = configInfo.getAnnAttrValue("trustStoreFile");
        AnnAttrValue trustStorePasswordAttrVal = configInfo.getAnnAttrValue("trustStorePassword");
        AnnAttrValue sslVerifyClientAttrVal = configInfo.getAnnAttrValue("sslVerifyClient");
        AnnAttrValue sslEnabledProtocolsAttrVal = configInfo.getAnnAttrValue("sslEnabledProtocols");
        AnnAttrValue ciphersAttrVal = configInfo.getAnnAttrValue("ciphers");
        AnnAttrValue sslProtocolAttrVal = configInfo.getAnnAttrValue("sslProtocol");
        AnnAttrValue hostAttrVal = configInfo.getAnnAttrValue("host");
        AnnAttrValue certificateValidationEnabledAttrValue = configInfo.getAnnAttrValue("validateCertEnabled");
        AnnAttrValue cacheSizeAttrValue = configInfo.getAnnAttrValue("cacheSize");
        AnnAttrValue cacheValidityPeriodAttrValue = configInfo.getAnnAttrValue("cacheValidityPeriod");
        ListenerConfiguration listenerConfiguration = new ListenerConfiguration();
        if (httpsPortAttrVal != null && httpsPortAttrVal.getIntValue() > 0L) {
            Parameter serverCiphers;
            listenerConfiguration.setPort(Math.toIntExact(httpsPortAttrVal.getIntValue()));
            listenerConfiguration.setScheme("https");
            if (hostAttrVal != null && hostAttrVal.getStringValue() != null) {
                listenerConfiguration.setHost(hostAttrVal.getStringValue());
            } else {
                listenerConfiguration.setHost("0.0.0.0");
            }
            if (keyStoreFileAttrVal == null || keyStoreFileAttrVal.getStringValue() == null) {
                throw new BallerinaConnectorException("Keystore location must be provided for secure connection");
            }
            if (keyStorePasswordAttrVal == null || keyStorePasswordAttrVal.getStringValue() == null) {
                throw new BallerinaConnectorException("Keystore password value must be provided for secure connection");
            }
            if (certPasswordAttrVal == null || certPasswordAttrVal.getStringValue() == null) {
                throw new BallerinaConnectorException("Certificate password value must be provided for secure connection");
            }
            if ((trustStoreFileAttrVal == null || trustStoreFileAttrVal.getStringValue() == null) && sslVerifyClientAttrVal != null) {
                throw new BallerinaException("Truststore location must be provided to enable Mutual SSL");
            }
            if ((trustStorePasswordAttrVal == null || trustStorePasswordAttrVal.getStringValue() == null) && sslVerifyClientAttrVal != null) {
                throw new BallerinaException("Truststore password value must be provided to enable Mutual SSL");
            }
            listenerConfiguration.setTLSStoreType("PKCS12");
            listenerConfiguration.setKeyStoreFile(keyStoreFileAttrVal.getStringValue());
            listenerConfiguration.setKeyStorePass(keyStorePasswordAttrVal.getStringValue());
            listenerConfiguration.setCertPass(certPasswordAttrVal.getStringValue());
            if (sslVerifyClientAttrVal != null) {
                listenerConfiguration.setVerifyClient(sslVerifyClientAttrVal.getStringValue());
            }
            if (trustStoreFileAttrVal != null) {
                listenerConfiguration.setTrustStoreFile(trustStoreFileAttrVal.getStringValue());
            }
            if (trustStorePasswordAttrVal != null) {
                listenerConfiguration.setTrustStorePass(trustStorePasswordAttrVal.getStringValue());
            }
            if (certificateValidationEnabledAttrValue != null && certificateValidationEnabledAttrValue.getBooleanValue()) {
                listenerConfiguration.setValidateCertEnabled(certificateValidationEnabledAttrValue.getBooleanValue());
                if (cacheSizeAttrValue != null) {
                    listenerConfiguration.setCacheSize((int)cacheSizeAttrValue.getIntValue());
                }
                if (cacheValidityPeriodAttrValue != null) {
                    listenerConfiguration.setCacheValidityPeriod((int)cacheValidityPeriodAttrValue.getIntValue());
                }
            }
            ArrayList<Parameter> serverParams = new ArrayList<Parameter>();
            if (sslEnabledProtocolsAttrVal != null && sslEnabledProtocolsAttrVal.getStringValue() != null) {
                serverCiphers = new Parameter("sslEnabledProtocols", sslEnabledProtocolsAttrVal.getStringValue());
                serverParams.add(serverCiphers);
            }
            if (ciphersAttrVal != null && ciphersAttrVal.getStringValue() != null) {
                serverCiphers = new Parameter("ciphers", ciphersAttrVal.getStringValue());
                serverParams.add(serverCiphers);
            }
            if (!serverParams.isEmpty()) {
                listenerConfiguration.setParameters(serverParams);
            }
            if (sslProtocolAttrVal != null) {
                listenerConfiguration.setSSLProtocol(sslProtocolAttrVal.getStringValue());
            }
            listenerConfiguration.setId(HttpUtil.getListenerInterface(listenerConfiguration.getHost(), listenerConfiguration.getPort()));
            listenerConfSet.add(listenerConfiguration);
        }
    }

    public static HTTPCarbonMessage createHttpCarbonMessage(boolean isRequest) {
        HTTPCarbonMessage httpCarbonMessage = isRequest ? new HTTPCarbonMessage((HttpMessage)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "")) : new HTTPCarbonMessage((HttpMessage)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
        httpCarbonMessage.completeMessage();
        return httpCarbonMessage;
    }

    public static void checkFunctionValidity(BStruct connectionStruct, HTTPCarbonMessage reqMsg) {
        HttpUtil.serverConnectionStructCheck(reqMsg);
        HttpUtil.methodInvocationCheck(connectionStruct, reqMsg);
    }

    private static void methodInvocationCheck(BStruct bStruct, HTTPCarbonMessage reqMsg) {
        if (bStruct.getNativeData(METHOD_ACCESSED) != null || reqMsg == null) {
            throw new IllegalStateException("illegal function invocation");
        }
        if (!HttpUtil.is100ContinueRequest(reqMsg)) {
            bStruct.addNativeData(METHOD_ACCESSED, (Object)true);
        }
    }

    public static void serverConnectionStructCheck(HTTPCarbonMessage reqMsg) {
        if (reqMsg == null) {
            throw new BallerinaException("operation not allowed:invalid Connection variable");
        }
    }

    private static boolean is100ContinueRequest(HTTPCarbonMessage reqMsg) {
        return "100-continue".equalsIgnoreCase(reqMsg.getHeader(HttpHeaderNames.EXPECT.toString()));
    }

    public static Annotation getServiceConfigAnnotation(Service service, String pkgPath) {
        List annotationList = service.getAnnotationList(pkgPath, "ServiceConfig");
        if (annotationList == null) {
            return null;
        }
        if (annotationList.size() > 1) {
            throw new BallerinaException("multiple service configuration annotations found in service: " + service.getName());
        }
        return annotationList.isEmpty() ? null : (Annotation)annotationList.get(0);
    }

    public static Annotation getServiceConfigStruct(Service service, String pkgPath) {
        List annotationList = service.getAnnotationList(pkgPath, "configuration");
        if (annotationList == null) {
            return null;
        }
        if (annotationList.size() > 1) {
            throw new BallerinaException("multiple service configuration annotations found in service: " + service.getName());
        }
        return annotationList.isEmpty() ? null : (Annotation)annotationList.get(0);
    }

    public static Annotation getResourceConfigAnnotation(Resource resource, String pkgPath) {
        List annotationList = resource.getAnnotationList(pkgPath, "ResourceConfig");
        if (annotationList == null) {
            return null;
        }
        if (annotationList.size() > 1) {
            throw new BallerinaException("multiple resource configuration annotations found in resource: " + resource.getServiceName() + "." + resource.getName());
        }
        return annotationList.isEmpty() ? null : (Annotation)annotationList.get(0);
    }

    private static int getIntValue(long val) {
        int intVal = (int)val;
        if ((long)intVal != val) {
            throw new IllegalArgumentException("invalid argument: " + val);
        }
        return intVal;
    }

    public static String getContentTypeFromTransportMessage(HTTPCarbonMessage transportMessage) {
        return transportMessage.getHeader(HttpHeaderNames.CONTENT_TYPE.toString()) != null ? transportMessage.getHeader(HttpHeaderNames.CONTENT_TYPE.toString()) : null;
    }

    public static String addBoundaryIfNotExist(HTTPCarbonMessage transportMessage, String contentType) {
        BString boundaryValue = HeaderUtil.extractBoundaryParameter((String)contentType);
        String boundaryString = boundaryValue != null ? boundaryValue.toString() : HttpUtil.addBoundaryParameter(transportMessage, contentType);
        return boundaryString;
    }

    private static String addBoundaryParameter(HTTPCarbonMessage transportMessage, String contentType) {
        String boundaryString = null;
        if (contentType != null && contentType.startsWith("multipart/")) {
            boundaryString = MimeUtil.getNewMultipartDelimiter();
            transportMessage.setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), contentType + "; " + "boundary" + "=" + boundaryString);
        }
        return boundaryString;
    }

    public static BStruct getGenericError(Context context, String errMsg) {
        PackageInfo errorPackageInfo = context.getProgramFile().getPackageInfo("ballerina.builtin");
        StructInfo errorStructInfo = errorPackageInfo.getStructInfo("error");
        BStruct genericError = new BStruct(errorStructInfo.getType());
        genericError.setStringField(0, errMsg);
        return genericError;
    }

    public static HttpWsConnectorFactory createHttpWsConnectionFactory() {
        return new DefaultHttpWsConnectorFactory();
    }

    public static void checkAndObserveHttpRequest(Context context, HTTPCarbonMessage message) {
        Optional observerContext = ObservabilityUtils.getParentContext((Context)context);
        observerContext.ifPresent(ctx -> {
            HttpUtil.injectHeaders(message, ObservabilityUtils.getContextProperties((ObserverContext)ctx));
            ctx.addTag("http.method", String.valueOf(message.getProperty("HTTP_METHOD")));
            ctx.addTag("http.url", String.valueOf(message.getProperty("TO")));
            ctx.addTag("peer.address", message.getProperty("host") + ":" + message.getProperty("port"));
            ctx.addTag("http.status_code", Integer.toString(0));
        });
    }

    public static void injectHeaders(HTTPCarbonMessage msg, Map<String, String> headers) {
        if (headers != null) {
            headers.forEach((key, value) -> msg.setHeader(key, String.valueOf(value)));
        }
    }

    private static void setChunkingHeader(Context context, HTTPCarbonMessage outboundResponseMsg) {
        Service serviceInstance = BLangConnectorSPIUtil.getService((ProgramFile)context.getProgramFile(), (BServiceType)context.getServiceInfo().getType());
        Annotation configAnnot = HttpUtil.getServiceConfigAnnotation(serviceInstance, "ballerina.http");
        if (configAnnot == null) {
            return;
        }
        String transferValue = configAnnot.getValue().getRefField("chunking").getStringValue();
        if (transferValue != null) {
            outboundResponseMsg.setProperty(CHUNKING_CONFIG, (Object)HttpUtil.getChunkConfig(transferValue));
        }
    }
}

