/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.util.List;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.ParamDetail;
import org.ballerinalang.net.http.HttpResource;

public class SignatureParams {
    private HttpResource resource;
    private final List<ParamDetail> paramDetails;
    private ParamDetail entityBody;
    private List<ParamDetail> pathParams;
    private int paramCount = 2;

    SignatureParams(HttpResource resource, List<ParamDetail> paramDetails) {
        this.resource = resource;
        this.paramDetails = paramDetails;
    }

    void validate() {
        if (this.resource.getEntityBodyAttributeValue() == null || this.resource.getEntityBodyAttributeValue().isEmpty()) {
            this.validatePathParam(this.paramDetails.subList(2, this.paramDetails.size()));
        } else {
            int lastParamIndex = this.paramDetails.size() - 1;
            this.validatePathParam(this.paramDetails.subList(2, lastParamIndex));
            this.validateEntityBodyParam(this.paramDetails.get(lastParamIndex));
        }
    }

    private void validatePathParam(List<ParamDetail> paramDetails) {
        for (ParamDetail param : paramDetails) {
            int varTag = param.getVarType().getTag();
            if (varTag != 3 && varTag != 1 && varTag != 4 && varTag != 2) {
                throw new BallerinaConnectorException("incompatible resource signature parameter type");
            }
            ++this.paramCount;
        }
        this.pathParams = paramDetails;
    }

    private void validateEntityBodyParam(ParamDetail entityBodyParam) {
        String entityBodyAttributeValue = this.resource.getEntityBodyAttributeValue();
        if (!entityBodyAttributeValue.equals(entityBodyParam.getVarName())) {
            throw new BallerinaConnectorException("expected '" + entityBodyAttributeValue + "' as param name, but found '" + entityBodyParam.getVarName() + "'");
        }
        int type = entityBodyParam.getVarType().getTag();
        if (type == 15 || type == 9 || type == 8 || type == 3 || type == 5) {
            this.entityBody = entityBodyParam;
            ++this.paramCount;
        } else {
            throw new BallerinaConnectorException("incompatible entity-body type : " + entityBodyParam.getVarType().getName());
        }
    }

    ParamDetail getEntityBody() {
        return this.entityBody;
    }

    List<ParamDetail> getPathParams() {
        return this.pathParams;
    }

    int getParamCount() {
        return this.paramCount;
    }
}

