/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.net.http.WebSocketDispatcher;
import org.ballerinalang.net.http.WebSocketOpenConnectionInfo;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketInitMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;

public class WebSocketClientConnectorListener
implements WebSocketConnectorListener {
    private WebSocketOpenConnectionInfo connectionInfo;

    public void setConnectionInfo(WebSocketOpenConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public void onMessage(WebSocketInitMessage webSocketInitMessage) {
        throw new BallerinaConnectorException("onOpen resource is not supported for client services");
    }

    public void onMessage(WebSocketTextMessage webSocketTextMessage) {
        WebSocketDispatcher.dispatchTextMessage(this.connectionInfo, webSocketTextMessage);
    }

    public void onMessage(WebSocketBinaryMessage webSocketBinaryMessage) {
        WebSocketDispatcher.dispatchBinaryMessage(this.connectionInfo, webSocketBinaryMessage);
    }

    public void onMessage(WebSocketControlMessage webSocketControlMessage) {
        WebSocketDispatcher.dispatchControlMessage(this.connectionInfo, webSocketControlMessage);
    }

    public void onMessage(WebSocketCloseMessage webSocketCloseMessage) {
        WebSocketDispatcher.dispatchCloseMessage(this.connectionInfo, webSocketCloseMessage);
    }

    public void onError(Throwable throwable) {
        throw new BallerinaConnectorException("Unexpected error occurred in WebSocket transport", throwable);
    }

    public void onIdleTimeout(WebSocketControlMessage controlMessage) {
        WebSocketDispatcher.dispatchIdleTimeout(this.connectionInfo, controlMessage);
    }
}

