/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.websocket.Session;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Executor;
import org.ballerinalang.connector.api.ParamDetail;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.model.values.BBlob;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.http.WebSocketOpenConnectionInfo;
import org.ballerinalang.net.http.WebSocketResourceCallableUnitCallback;
import org.ballerinalang.net.http.WebSocketService;
import org.ballerinalang.net.http.WebSocketServicesRegistry;
import org.ballerinalang.net.http.WebSocketUtil;
import org.ballerinalang.services.ErrorHandlerUtils;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlSignal;
import org.wso2.transport.http.netty.contract.websocket.WebSocketMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class WebSocketDispatcher {
    public static WebSocketService findService(WebSocketServicesRegistry servicesRegistry, Map<String, String> pathParams, WebSocketMessage webSocketMessage, HTTPCarbonMessage msg) {
        try {
            URI requestUri;
            String serviceUri = webSocketMessage.getTarget();
            serviceUri = WebSocketUtil.refactorUri(serviceUri);
            try {
                requestUri = URI.create(serviceUri);
            }
            catch (IllegalArgumentException e) {
                throw new BallerinaConnectorException(e.getMessage());
            }
            WebSocketService service = servicesRegistry.getUriTemplate().matches(requestUri.getPath(), pathParams, webSocketMessage);
            if (service == null) {
                throw new BallerinaConnectorException("no Service found to handle the service request: " + serviceUri);
            }
            msg.setProperty("QUERY_STR", (Object)requestUri.getRawQuery());
            return service;
        }
        catch (Throwable throwable) {
            ErrorHandlerUtils.printError((Throwable)throwable);
            throw new BallerinaConnectorException("no Service found to handle the service request");
        }
    }

    public static void dispatchTextMessage(WebSocketOpenConnectionInfo connectionInfo, WebSocketTextMessage textMessage) {
        WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
        WebSocketService wsService = connectionInfo.getService();
        Resource onTextMessageResource = wsService.getResourceByName("onText");
        if (onTextMessageResource == null) {
            webSocketConnection.readNextFrame();
            return;
        }
        List paramDetails = onTextMessageResource.getParamDetails();
        BValue[] bValues = new BValue[paramDetails.size()];
        bValues[0] = connectionInfo.getWebSocketEndpoint();
        bValues[1] = new BString(textMessage.getText());
        if (paramDetails.size() == 3) {
            bValues[2] = new BBoolean(textMessage.isFinalFragment());
        }
        Executor.submit((Resource)onTextMessageResource, (CallableUnitCallback)new WebSocketResourceCallableUnitCallback(webSocketConnection), null, null, (BValue[])bValues);
    }

    public static void dispatchBinaryMessage(WebSocketOpenConnectionInfo connectionInfo, WebSocketBinaryMessage binaryMessage) {
        WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
        WebSocketService wsService = connectionInfo.getService();
        Resource onBinaryMessageResource = wsService.getResourceByName("onBinary");
        if (onBinaryMessageResource == null) {
            webSocketConnection.readNextFrame();
            return;
        }
        List paramDetails = onBinaryMessageResource.getParamDetails();
        BValue[] bValues = new BValue[paramDetails.size()];
        bValues[0] = connectionInfo.getWebSocketEndpoint();
        bValues[1] = new BBlob(binaryMessage.getByteArray());
        if (paramDetails.size() == 3) {
            bValues[2] = new BBoolean(binaryMessage.isFinalFragment());
        }
        Executor.submit((Resource)onBinaryMessageResource, (CallableUnitCallback)new WebSocketResourceCallableUnitCallback(webSocketConnection), null, null, (BValue[])bValues);
    }

    public static void dispatchControlMessage(WebSocketOpenConnectionInfo connectionInfo, WebSocketControlMessage controlMessage) {
        if (controlMessage.getControlSignal() == WebSocketControlSignal.PING) {
            WebSocketDispatcher.dispatchPingMessage(connectionInfo, controlMessage);
        } else if (controlMessage.getControlSignal() == WebSocketControlSignal.PONG) {
            WebSocketDispatcher.dispatchPongMessage(connectionInfo, controlMessage);
        } else {
            throw new BallerinaConnectorException("Received unknown control signal");
        }
    }

    private static void dispatchPingMessage(WebSocketOpenConnectionInfo connectionInfo, WebSocketControlMessage controlMessage) {
        WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
        WebSocketService wsService = connectionInfo.getService();
        Resource onPingMessageResource = wsService.getResourceByName("onPing");
        if (onPingMessageResource == null) {
            WebSocketDispatcher.pingAutomatically(controlMessage);
            webSocketConnection.readNextFrame();
            return;
        }
        List paramDetails = onPingMessageResource.getParamDetails();
        BValue[] bValues = new BValue[paramDetails.size()];
        bValues[0] = connectionInfo.getWebSocketEndpoint();
        bValues[1] = new BBlob(controlMessage.getByteArray());
        Executor.submit((Resource)onPingMessageResource, (CallableUnitCallback)new WebSocketResourceCallableUnitCallback(webSocketConnection), null, null, (BValue[])bValues);
    }

    private static void dispatchPongMessage(WebSocketOpenConnectionInfo connectionInfo, WebSocketControlMessage controlMessage) {
        WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
        WebSocketService wsService = connectionInfo.getService();
        Resource onPongMessageResource = wsService.getResourceByName("onPong");
        if (onPongMessageResource == null) {
            webSocketConnection.readNextFrame();
            return;
        }
        List paramDetails = onPongMessageResource.getParamDetails();
        BValue[] bValues = new BValue[paramDetails.size()];
        bValues[0] = connectionInfo.getWebSocketEndpoint();
        bValues[1] = new BBlob(controlMessage.getByteArray());
        Executor.submit((Resource)onPongMessageResource, (CallableUnitCallback)new WebSocketResourceCallableUnitCallback(webSocketConnection), null, null, (BValue[])bValues);
    }

    public static void dispatchCloseMessage(WebSocketOpenConnectionInfo connectionInfo, WebSocketCloseMessage closeMessage) {
        WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
        WebSocketService wsService = connectionInfo.getService();
        Resource onCloseResource = wsService.getResourceByName("onClose");
        if (onCloseResource == null) {
            webSocketConnection.readNextFrame();
            return;
        }
        List paramDetails = onCloseResource.getParamDetails();
        BValue[] bValues = new BValue[paramDetails.size()];
        bValues[0] = connectionInfo.getWebSocketEndpoint();
        bValues[1] = new BInteger((long)closeMessage.getCloseCode());
        bValues[2] = new BString(closeMessage.getCloseReason());
        Executor.submit((Resource)onCloseResource, (CallableUnitCallback)new WebSocketResourceCallableUnitCallback(webSocketConnection), null, null, (BValue[])bValues);
    }

    public static void dispatchIdleTimeout(WebSocketOpenConnectionInfo connectionInfo, WebSocketControlMessage controlMessage) {
        WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
        WebSocketService wsService = connectionInfo.getService();
        Resource onIdleTimeoutResource = wsService.getResourceByName("onIdleTimeout");
        if (onIdleTimeoutResource == null) {
            webSocketConnection.readNextFrame();
            return;
        }
        List paramDetails = onIdleTimeoutResource.getParamDetails();
        BValue[] bValues = new BValue[paramDetails.size()];
        bValues[0] = connectionInfo.getWebSocketEndpoint();
        Executor.submit((Resource)onIdleTimeoutResource, (CallableUnitCallback)new WebSocketResourceCallableUnitCallback(webSocketConnection), null, null, (BValue[])bValues);
    }

    private static void pingAutomatically(WebSocketControlMessage controlMessage) {
        Session session = controlMessage.getWebSocketConnection().getSession();
        try {
            session.getAsyncRemote().sendPong(controlMessage.getPayload());
        }
        catch (IOException ex) {
            ErrorHandlerUtils.printError((Throwable)ex);
        }
    }

    public static void setPathParams(BValue[] bValues, List<ParamDetail> paramDetails, Map<String, String> pathParams, int defaultArgSize) {
        int parameterDetailsSize = paramDetails.size();
        if (parameterDetailsSize > defaultArgSize) {
            for (int i = defaultArgSize; i < parameterDetailsSize; ++i) {
                bValues[i] = new BString(pathParams.get(paramDetails.get(i).getVarName()));
            }
        }
    }
}

