/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import io.netty.handler.codec.http.HttpMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Executor;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.WebSocketConnectionManager;
import org.ballerinalang.net.http.WebSocketDispatcher;
import org.ballerinalang.net.http.WebSocketOpenConnectionInfo;
import org.ballerinalang.net.http.WebSocketService;
import org.ballerinalang.net.http.WebSocketServicesRegistry;
import org.ballerinalang.net.http.WebSocketUtil;
import org.ballerinalang.net.http.caching.RequestCacheControlStruct;
import org.ballerinalang.services.ErrorHandlerUtils;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.observability.ObservabilityUtils;
import org.ballerinalang.util.observability.ObserverContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketInitMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;
import org.wso2.transport.http.netty.contractimpl.websocket.message.DefaultWebSocketInitMessage;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class WebSocketServerConnectorListener
implements WebSocketConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServerConnectorListener.class);
    private final WebSocketServicesRegistry servicesRegistry;
    private final WebSocketConnectionManager connectionManager;

    public WebSocketServerConnectorListener(WebSocketServicesRegistry servicesRegistry) {
        this.servicesRegistry = servicesRegistry;
        this.connectionManager = new WebSocketConnectionManager();
    }

    public void onMessage(final WebSocketInitMessage webSocketInitMessage) {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        HTTPCarbonMessage msg = new HTTPCarbonMessage((HttpMessage)((DefaultWebSocketInitMessage)webSocketInitMessage).getHttpRequest());
        final WebSocketService wsService = WebSocketDispatcher.findService(this.servicesRegistry, pathParams, (WebSocketMessage)webSocketInitMessage, msg);
        Resource onUpgradeResource = wsService.getUpgradeResource();
        if (onUpgradeResource != null) {
            BStruct httpServiceEndpoint = BLangConnectorSPIUtil.createBStruct((ProgramFile)wsService.getResources()[0].getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"Listener", (Object[])new Object[0]);
            BStruct httpConnection = BLangConnectorSPIUtil.createBStruct((ProgramFile)wsService.getResources()[0].getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"Connection", (Object[])new Object[0]);
            httpConnection.addNativeData("WEBSOCKET_MESSAGE", (Object)webSocketInitMessage);
            httpConnection.addNativeData("WebSocketService", (Object)wsService);
            httpConnection.addNativeData("WEBSOCKET_CONNECTION_MANAGER", (Object)this.connectionManager);
            httpServiceEndpoint.setRefField(0, (BRefType)httpConnection);
            BStruct inRequest = BLangConnectorSPIUtil.createBStruct((ProgramFile)WebSocketUtil.getProgramFile(wsService.getResources()[0]), (String)"ballerina.http", (String)"Request", (Object[])new Object[0]);
            BStruct inRequestEntity = BLangConnectorSPIUtil.createBStruct((ProgramFile)WebSocketUtil.getProgramFile(wsService.getResources()[0]), (String)"ballerina.mime", (String)"Entity", (Object[])new Object[0]);
            BStruct mediaType = BLangConnectorSPIUtil.createBStruct((ProgramFile)WebSocketUtil.getProgramFile(wsService.getResources()[0]), (String)"ballerina.mime", (String)"MediaType", (Object[])new Object[0]);
            BStruct cacheControlStruct = BLangConnectorSPIUtil.createBStruct((ProgramFile)WebSocketUtil.getProgramFile(wsService.getResources()[0]), (String)"ballerina.http", (String)"RequestCacheControl", (Object[])new Object[0]);
            RequestCacheControlStruct requestCacheControl = new RequestCacheControlStruct(cacheControlStruct);
            HttpUtil.populateInboundRequest(inRequest, inRequestEntity, mediaType, msg, requestCacheControl);
            List paramDetails = onUpgradeResource.getParamDetails();
            BValue[] bValues = new BValue[paramDetails.size()];
            bValues[0] = httpServiceEndpoint;
            bValues[1] = inRequest;
            WebSocketDispatcher.setPathParams(bValues, paramDetails, pathParams, 2);
            Optional observerContext = ObservabilityUtils.startServerObservation((String)"ws", (String)onUpgradeResource.getServiceName(), (String)onUpgradeResource.getName(), null);
            Executor.submit((Resource)onUpgradeResource, (CallableUnitCallback)new CallableUnitCallback(){

                public void notifySuccess() {
                    if (!webSocketInitMessage.isCancelled() && !webSocketInitMessage.isHandshakeStarted()) {
                        WebSocketUtil.handleHandshake(wsService, WebSocketServerConnectorListener.this.connectionManager, null, webSocketInitMessage, null, null);
                    } else {
                        Resource onOpenResource = wsService.getResourceByName("onOpen");
                        WebSocketOpenConnectionInfo connectionInfo = WebSocketServerConnectorListener.this.connectionManager.getConnectionInfo(webSocketInitMessage.getSessionID());
                        WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
                        if (onOpenResource != null) {
                            BStruct webSocketEndpoint = connectionInfo.getWebSocketEndpoint();
                            WebSocketUtil.executeOnOpenResource(onOpenResource, webSocketEndpoint, webSocketConnection);
                        } else {
                            connectionInfo.getWebSocketConnection().readNextFrame();
                        }
                    }
                }

                public void notifyFailure(BStruct error) {
                    ErrorHandlerUtils.printError((String)("error: " + BLangVMErrors.getPrintableStackTrace((BStruct)error)));
                }
            }, null, (ObserverContext)observerContext.orElse(null), (BValue[])bValues);
        } else {
            WebSocketUtil.handleHandshake(wsService, this.connectionManager, null, webSocketInitMessage, null, null);
        }
    }

    public void onMessage(WebSocketTextMessage webSocketTextMessage) {
        WebSocketDispatcher.dispatchTextMessage(this.connectionManager.getConnectionInfo(webSocketTextMessage.getSessionID()), webSocketTextMessage);
    }

    public void onMessage(WebSocketBinaryMessage webSocketBinaryMessage) {
        WebSocketDispatcher.dispatchBinaryMessage(this.connectionManager.getConnectionInfo(webSocketBinaryMessage.getSessionID()), webSocketBinaryMessage);
    }

    public void onMessage(WebSocketControlMessage webSocketControlMessage) {
        WebSocketDispatcher.dispatchControlMessage(this.connectionManager.getConnectionInfo(webSocketControlMessage.getSessionID()), webSocketControlMessage);
    }

    public void onMessage(WebSocketCloseMessage webSocketCloseMessage) {
        WebSocketDispatcher.dispatchCloseMessage(this.connectionManager.removeConnectionInfo(webSocketCloseMessage.getSessionID()), webSocketCloseMessage);
    }

    public void onError(Throwable throwable) {
        log.error("Unexpected error occurred in WebSocket transport", throwable);
    }

    public void onIdleTimeout(WebSocketControlMessage controlMessage) {
        WebSocketDispatcher.dispatchIdleTimeout(this.connectionManager.getConnectionInfo(controlMessage.getSessionID()), controlMessage);
    }
}

