/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.connector.api.Annotation;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.WebSocketUtil;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.exceptions.BallerinaException;

public class WebSocketService
implements Service {
    private final Service service;
    private final String[] negotiableSubProtocols;
    private final int idleTimeoutInSeconds;
    private final int maxFrameSize;
    private final Map<String, Resource> resourceMap = new ConcurrentHashMap<String, Resource>();
    private String basePath;
    private Resource upgradeResource;
    private static final int DEFAULT_MAX_FRAME_SIZE = 65536;

    public WebSocketService(Service service) {
        this.service = service;
        for (Resource resource : service.getResources()) {
            this.resourceMap.put(resource.getName(), resource);
        }
        Annotation configAnnotation = WebSocketUtil.getServiceConfigAnnotation(service, "ballerina.http");
        Struct configAnnotationStruct = null;
        if (configAnnotation != null && (configAnnotationStruct = configAnnotation.getValue()) != null) {
            this.negotiableSubProtocols = this.findNegotiableSubProtocols(configAnnotationStruct);
            this.idleTimeoutInSeconds = this.findIdleTimeoutInSeconds(configAnnotationStruct);
            this.maxFrameSize = this.findMaxFrameSize(configAnnotationStruct);
        } else {
            this.negotiableSubProtocols = null;
            this.idleTimeoutInSeconds = 0;
            this.maxFrameSize = 65536;
        }
        this.basePath = this.findFullWebSocketUpgradePath(configAnnotationStruct);
        this.upgradeResource = null;
    }

    public WebSocketService(String httpBasePath, Resource upgradeResource, Service service) {
        this(service);
        Annotation resourceConfigAnnotation = HttpResource.getResourceConfigAnnotation(upgradeResource);
        if (resourceConfigAnnotation == null) {
            throw new BallerinaException("Cannot find a resource config for resource " + upgradeResource.getName());
        }
        Struct webSocketConfig = resourceConfigAnnotation.getValue().getStructField("webSocketUpgrade");
        String upgradePath = webSocketConfig.getStringField("upgradePath");
        this.basePath = httpBasePath.concat(upgradePath);
        this.upgradeResource = upgradeResource;
    }

    public String getName() {
        return this.service.getName();
    }

    public String getPackage() {
        return this.service.getPackage();
    }

    public String getEndpointName() {
        return this.service.getEndpointName();
    }

    public List<Annotation> getAnnotationList(String pkgPath, String name) {
        return this.service.getAnnotationList(pkgPath, name);
    }

    public Resource[] getResources() {
        return this.service.getResources();
    }

    public ServiceInfo getServiceInfo() {
        return this.service.getServiceInfo();
    }

    public String getPackageVersion() {
        return null;
    }

    public Resource getResourceByName(String resourceName) {
        return this.resourceMap.get(resourceName);
    }

    public String[] getNegotiableSubProtocols() {
        return this.negotiableSubProtocols;
    }

    public Resource getUpgradeResource() {
        return this.upgradeResource;
    }

    public int getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    private String[] findNegotiableSubProtocols(Struct annAttrSubProtocols) {
        if (annAttrSubProtocols == null) {
            return null;
        }
        Value[] subProtocolsInAnnotation = annAttrSubProtocols.getArrayField("subProtocols");
        if (subProtocolsInAnnotation == null) {
            return null;
        }
        String[] negotiableSubProtocols = new String[subProtocolsInAnnotation.length];
        for (int i = 0; i < subProtocolsInAnnotation.length; ++i) {
            negotiableSubProtocols[i] = subProtocolsInAnnotation[i].getStringValue();
        }
        return negotiableSubProtocols;
    }

    private int findIdleTimeoutInSeconds(Struct annAttrIdleTimeout) {
        return (int)annAttrIdleTimeout.getIntField("idleTimeoutInSeconds");
    }

    private int findMaxFrameSize(Struct annotation) {
        int size = (int)annotation.getIntField("maxFrameSize");
        if (size <= 0) {
            size = 65536;
        }
        return size;
    }

    public String getBasePath() {
        return this.basePath;
    }

    private String findFullWebSocketUpgradePath(Struct annStruct) {
        String basePathVal;
        String basePath = null;
        if (annStruct != null && (basePathVal = annStruct.getStringField("path")) != null && !basePathVal.trim().isEmpty()) {
            basePath = WebSocketUtil.refactorUri(basePathVal);
        }
        if (basePath == null) {
            basePath = "/".concat(this.getName());
        }
        return basePath;
    }
}

