/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.net.http.WebSocketDataElement;
import org.ballerinalang.net.http.WebSocketDataElementFactory;
import org.ballerinalang.net.http.WebSocketService;
import org.ballerinalang.net.uri.URITemplate;
import org.ballerinalang.net.uri.URITemplateException;
import org.ballerinalang.net.uri.parser.Literal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketMessage;

public class WebSocketServicesRegistry {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServicesRegistry.class);
    private URITemplate<WebSocketService, WebSocketMessage> uriTemplate;

    public void registerService(WebSocketService service) {
        String basePath = service.getBasePath();
        if (basePath == null) {
            basePath = "/";
        }
        basePath = this.urlDecode(basePath);
        try {
            this.getUriTemplate().parse(basePath, service, new WebSocketDataElementFactory());
        }
        catch (UnsupportedEncodingException | URITemplateException e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
        logger.info("Service deployed : " + service.getName() + " with context " + basePath);
    }

    public URITemplate<WebSocketService, WebSocketMessage> getUriTemplate() throws URITemplateException {
        if (this.uriTemplate == null) {
            this.uriTemplate = new URITemplate<WebSocketService, WebSocketMessage>(new Literal<WebSocketService, WebSocketMessage>(new WebSocketDataElement(), "/"));
        }
        return this.uriTemplate;
    }

    private String urlDecode(String basePath) {
        try {
            basePath = URLDecoder.decode(basePath, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
        return basePath;
    }
}

