/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.Annotation;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Executor;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.http.WebSocketConnectionManager;
import org.ballerinalang.net.http.WebSocketOpenConnectionInfo;
import org.ballerinalang.net.http.WebSocketService;
import org.ballerinalang.services.ErrorHandlerUtils;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.contract.websocket.HandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.HandshakeListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketInitMessage;

public abstract class WebSocketUtil {
    public static ProgramFile getProgramFile(Resource resource) {
        return resource.getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile();
    }

    public static Annotation getServiceConfigAnnotation(Service service, String pkgPath) {
        List annotationList = service.getAnnotationList(pkgPath, "WebSocketServiceConfig");
        if (annotationList == null) {
            return null;
        }
        if (annotationList.size() > 1) {
            throw new BallerinaException("Multiple service configuration annotations found in service: " + service.getName());
        }
        return annotationList.isEmpty() ? null : (Annotation)annotationList.get(0);
    }

    public static void handleHandshake(final WebSocketService wsService, final WebSocketConnectionManager connectionManager, HttpHeaders headers, WebSocketInitMessage initMessage, final Context context, final CallableUnitCallback callback) {
        String[] subProtocols = wsService.getNegotiableSubProtocols();
        int idleTimeoutInSeconds = wsService.getIdleTimeoutInSeconds();
        int maxFrameSize = wsService.getMaxFrameSize();
        HandshakeFuture future = initMessage.handshake(subProtocols, true, idleTimeoutInSeconds * 1000, headers, maxFrameSize);
        future.setHandshakeListener(new HandshakeListener(){

            public void onSuccess(WebSocketConnection webSocketConnection) {
                BStruct webSocketEndpoint = BLangConnectorSPIUtil.createObject((ProgramFile)wsService.getResources()[0].getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"WebSocketListener", (BValue[])new BValue[0]);
                BStruct webSocketConnector = BLangConnectorSPIUtil.createObject((ProgramFile)wsService.getResources()[0].getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"WebSocketConnector", (BValue[])new BValue[0]);
                webSocketEndpoint.setRefField(1, (BRefType)webSocketConnector);
                WebSocketUtil.populateEndpoint(webSocketConnection, webSocketEndpoint);
                webSocketConnector.addNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION", (Object)webSocketConnection);
                WebSocketOpenConnectionInfo connectionInfo = new WebSocketOpenConnectionInfo(wsService, webSocketEndpoint);
                connectionManager.addConnection(webSocketConnection.getId(), connectionInfo);
                webSocketConnector.addNativeData("WEBSOCKET_CONNECTION_MANAGER", (Object)connectionManager);
                if (context != null && callback != null) {
                    context.setReturnValues(new BValue[]{webSocketEndpoint});
                    callback.notifySuccess();
                } else {
                    Resource onOpenResource = wsService.getResourceByName("onOpen");
                    if (onOpenResource != null) {
                        WebSocketUtil.executeOnOpenResource(onOpenResource, webSocketEndpoint, webSocketConnection);
                    } else {
                        webSocketConnection.readNextFrame();
                        webSocketConnector.setBooleanField(0, 1);
                    }
                }
            }

            public void onError(Throwable throwable) {
                if (context != null) {
                    context.setReturnValues(new BValue[0]);
                }
                if (callback != null) {
                    callback.notifyFailure(BLangConnectorSPIUtil.createBStruct((Context)context, (String)"ballerina.http", (String)"WebSocketConnectorError", (Object[])new Object[]{"Unable to complete handshake: " + throwable.getMessage()}));
                }
                throw new BallerinaConnectorException("Unable to complete handshake", throwable);
            }
        });
    }

    public static void executeOnOpenResource(Resource onOpenResource, BStruct webSocketEndpoint, final WebSocketConnection webSocketConnection) {
        List paramDetails = onOpenResource.getParamDetails();
        BValue[] bValues = new BValue[paramDetails.size()];
        bValues[0] = webSocketEndpoint;
        final BStruct webSocketConnector = (BStruct)webSocketEndpoint.getRefField(1);
        CallableUnitCallback onOpenCallableUnitCallback = new CallableUnitCallback(){

            public void notifySuccess() {
                if (webSocketConnector.getBooleanField(0) == 0) {
                    webSocketConnection.readNextFrame();
                    webSocketConnector.setBooleanField(0, 1);
                }
            }

            public void notifyFailure(BStruct error) {
                if (webSocketConnector.getBooleanField(0) == 0) {
                    webSocketConnection.readNextFrame();
                    webSocketConnector.setBooleanField(0, 1);
                }
                ErrorHandlerUtils.printError((String)("error: " + BLangVMErrors.getPrintableStackTrace((BStruct)error)));
            }
        };
        Executor.submit((Resource)onOpenResource, (CallableUnitCallback)onOpenCallableUnitCallback, null, null, (BValue[])bValues);
    }

    public static void populateEndpoint(WebSocketConnection webSocketConnection, BStruct webSocketEndpoint) {
        webSocketEndpoint.setStringField(0, webSocketConnection.getId());
        webSocketEndpoint.setStringField(1, webSocketConnection.getSession().getNegotiatedSubprotocol());
        webSocketEndpoint.setBooleanField(0, webSocketConnection.getSession().isSecure() ? 1 : 0);
        webSocketEndpoint.setBooleanField(1, webSocketConnection.getSession().isOpen() ? 1 : 0);
    }

    public static void handleWebSocketCallback(Context context, CallableUnitCallback callback, ChannelFuture webSocketChannelFuture) throws InterruptedException {
        webSocketChannelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            Throwable cause = future.cause();
            if (!future.isSuccess() && cause != null) {
                context.setReturnValues(new BValue[]{WebSocketUtil.createWebSocketConnectorError(context, future.cause().getMessage())});
            } else {
                context.setReturnValues(new BValue[0]);
            }
            callback.notifySuccess();
        }));
    }

    public static BStruct createWebSocketConnectorError(Context context, String errorMsg) {
        return BLangConnectorSPIUtil.createBStruct((Context)context, (String)"ballerina.http", (String)"WebSocketConnectorError", (Object[])new Object[]{errorMsg, new BValue[0]});
    }

    public static String refactorUri(String uri) {
        if (!uri.startsWith("/")) {
            uri = "/".concat(uri);
        }
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return uri;
    }
}

