/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.mime.util.MultipartDataSource;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.net.http.AcceptEncodingConfig;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.caching.ResponseCacheControlStruct;
import org.ballerinalang.runtime.message.MessageDataSource;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.observability.ObservabilityUtils;
import org.ballerinalang.util.transactions.LocalTransactionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ClientConnectorException;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpClientConnectorListener;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.exception.EndpointTimeOutException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;
import org.wso2.transport.http.netty.message.PooledDataStreamerFactory;
import org.wso2.transport.http.netty.message.ResponseHandle;

public abstract class AbstractHTTPAction
implements NativeCallableUnit {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHTTPAction.class);
    private static final String CACHE_BALLERINA_VERSION = System.getProperty("ballerina.version");

    protected HTTPCarbonMessage createOutboundRequestMsg(Context context) {
        BStruct bConnector = (BStruct)context.getRefArgument(0);
        String path = context.getStringArgument(0);
        BStruct requestStruct = (BStruct)context.getNullableRefArgument(1);
        if (requestStruct == null) {
            requestStruct = BLangConnectorSPIUtil.createBStruct((Context)context, (String)"ballerina.http", (String)"Request", (Object[])new Object[0]);
        }
        HTTPCarbonMessage requestMsg = HttpUtil.getCarbonMsg(requestStruct, HttpUtil.createHttpCarbonMessage(true));
        HttpUtil.checkEntityAvailability(context, requestStruct);
        HttpUtil.enrichOutboundMessage(requestMsg, requestStruct);
        this.prepareOutboundRequest(context, bConnector, path, requestMsg);
        AcceptEncodingConfig acceptEncodingConfig = AbstractHTTPAction.getAcceptEncodingConfig(this.getAcceptEncodingConfigFromEndpointConfig(bConnector));
        this.handleAcceptEncodingHeader(requestMsg, acceptEncodingConfig);
        return requestMsg;
    }

    private String getAcceptEncodingConfigFromEndpointConfig(BStruct httpClientStruct) {
        Struct clientEndpointConfig = BLangConnectorSPIUtil.toStruct((BStruct)httpClientStruct);
        Struct epConfig = (Struct)clientEndpointConfig.getNativeData("config");
        if (epConfig == null) {
            return "AUTO";
        }
        return epConfig.getRefField("acceptEncoding").getStringValue();
    }

    private static AcceptEncodingConfig getAcceptEncodingConfig(String acceptEncodingConfig) {
        if ("AUTO".equalsIgnoreCase(acceptEncodingConfig)) {
            return AcceptEncodingConfig.AUTO;
        }
        if ("ALWAYS".equalsIgnoreCase(acceptEncodingConfig)) {
            return AcceptEncodingConfig.ALWAYS;
        }
        if ("NEVER".equalsIgnoreCase(acceptEncodingConfig)) {
            return AcceptEncodingConfig.NEVER;
        }
        throw new BallerinaConnectorException("Invalid configuration found for Accept-Encoding: " + acceptEncodingConfig);
    }

    private void handleAcceptEncodingHeader(HTTPCarbonMessage outboundRequest, AcceptEncodingConfig acceptEncodingConfig) {
        if (acceptEncodingConfig == AcceptEncodingConfig.ALWAYS && outboundRequest.getHeader(HttpHeaderNames.ACCEPT_ENCODING.toString()) == null) {
            outboundRequest.setHeader(HttpHeaderNames.ACCEPT_ENCODING.toString(), "deflate, gzip");
        } else if (acceptEncodingConfig == AcceptEncodingConfig.NEVER && outboundRequest.getHeader(HttpHeaderNames.ACCEPT_ENCODING.toString()) != null) {
            outboundRequest.removeHeader(HttpHeaderNames.ACCEPT_ENCODING.toString());
        }
    }

    protected void prepareOutboundRequest(Context context, BStruct connector, String path, HTTPCarbonMessage outboundRequest) {
        this.validateParams(connector);
        if (context.isInTransaction()) {
            LocalTransactionInfo localTransactionInfo = context.getLocalTransactionInfo();
            outboundRequest.setHeader("x-b7a-xid", localTransactionInfo.getGlobalTransactionId());
            outboundRequest.setHeader("x-b7a-register-at", localTransactionInfo.getURL());
        }
        try {
            String uri = connector.getStringField(0) + path;
            URL url = new URL(uri);
            int port = this.getOutboundReqPort(url);
            String host = url.getHost();
            this.setOutboundReqProperties(outboundRequest, url, port, host);
            this.setOutboundReqHeaders(outboundRequest, port, host);
        }
        catch (MalformedURLException e) {
            throw new BallerinaException("Malformed url specified. " + e.getMessage());
        }
        catch (Throwable t) {
            throw new BallerinaException("Failed to prepare request. " + t.getMessage());
        }
    }

    private void setOutboundReqHeaders(HTTPCarbonMessage outboundRequest, int port, String host) {
        HttpHeaders headers = outboundRequest.getHeaders();
        this.setHostHeader(host, port, headers);
        this.setOutboundUserAgent(headers);
        this.removeConnectionHeader(headers);
    }

    private void setOutboundReqProperties(HTTPCarbonMessage outboundRequest, URL url, int port, String host) {
        outboundRequest.setProperty("host", (Object)host);
        outboundRequest.setProperty("port", (Object)port);
        String outboundReqPath = this.getOutboundReqPath(url);
        outboundRequest.setProperty("TO", (Object)outboundReqPath);
        outboundRequest.setProperty("PROTOCOL", (Object)url.getProtocol());
    }

    private void setHostHeader(String host, int port, HttpHeaders headers) {
        if (port == 80 || port == 443) {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)host);
        } else {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)(host + ":" + port));
        }
    }

    private void removeConnectionHeader(HttpHeaders headers) {
        if (headers.contains((CharSequence)HttpHeaderNames.CONNECTION)) {
            headers.remove((CharSequence)HttpHeaderNames.CONNECTION);
        }
    }

    private void setOutboundUserAgent(HttpHeaders headers) {
        String userAgent = CACHE_BALLERINA_VERSION != null ? "ballerina/" + CACHE_BALLERINA_VERSION : "ballerina";
        if (!headers.contains((CharSequence)HttpHeaderNames.USER_AGENT)) {
            headers.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)userAgent);
        }
    }

    private String getOutboundReqPath(URL url) {
        String toPath = url.getPath();
        String query = url.getQuery();
        if (query != null) {
            toPath = toPath + "?" + query;
        }
        return toPath;
    }

    private int getOutboundReqPort(URL url) {
        int port = 80;
        if (url.getPort() != -1) {
            port = url.getPort();
        } else if (url.getProtocol().equalsIgnoreCase("https")) {
            port = 443;
        }
        return port;
    }

    private void validateParams(BStruct connector) {
        if (connector == null || connector.getStringField(0) == null) {
            throw new BallerinaException("Connector parameters not defined correctly.");
        }
    }

    protected void executeNonBlockingAction(DataContext dataContext) throws ClientConnectorException {
        this.executeNonBlockingAction(dataContext, false);
    }

    protected void executeNonBlockingAction(DataContext dataContext, boolean async) throws ClientConnectorException {
        Object remoteAddress;
        Object poolableByteBufferFactory;
        HTTPCarbonMessage outboundRequestMsg = dataContext.getOutboundRequest();
        Object sourceHandler = outboundRequestMsg.getProperty("SRC_HANDLER");
        if (sourceHandler == null) {
            outboundRequestMsg.setProperty("SRC_HANDLER", dataContext.context.getProperty("SRC_HANDLER"));
        }
        if ((poolableByteBufferFactory = outboundRequestMsg.getProperty("POOLED_BYTE_BUFFER_FACTORY")) == null) {
            outboundRequestMsg.setProperty("POOLED_BYTE_BUFFER_FACTORY", dataContext.context.getProperty("POOLED_BYTE_BUFFER_FACTORY"));
        }
        if ((remoteAddress = outboundRequestMsg.getProperty("REMOTE_ADDRESS")) == null) {
            outboundRequestMsg.setProperty("REMOTE_ADDRESS", dataContext.context.getProperty("REMOTE_ADDRESS"));
        }
        outboundRequestMsg.setProperty("ORIGIN_HOST", dataContext.context.getProperty("ORIGIN_HOST"));
        this.sendOutboundRequest(dataContext, outboundRequestMsg, async);
    }

    private void sendOutboundRequest(DataContext dataContext, HTTPCarbonMessage outboundRequestMsg, boolean async) {
        try {
            this.send(dataContext, outboundRequestMsg, async);
        }
        catch (BallerinaConnectorException e) {
            dataContext.notifyReply(null, HttpUtil.getHttpConnectorError(dataContext.context, e));
        }
        catch (Exception e) {
            BallerinaException exception = new BallerinaException("Failed to send outboundRequestMsg to the backend", (Throwable)e, dataContext.context);
            dataContext.notifyReply(null, HttpUtil.getHttpConnectorError(dataContext.context, exception));
        }
    }

    private void send(DataContext dataContext, HTTPCarbonMessage outboundRequestMsg, boolean async) throws Exception {
        BStruct bConnector = (BStruct)dataContext.context.getRefArgument(0);
        Struct httpClient = BLangConnectorSPIUtil.toStruct((BStruct)bConnector);
        HttpClientConnector clientConnector = (HttpClientConnector)httpClient.getNativeData("CallerActions");
        String contentType = HttpUtil.getContentTypeFromTransportMessage(outboundRequestMsg);
        String boundaryString = null;
        if (HeaderUtil.isMultipart((String)contentType)) {
            boundaryString = HttpUtil.addBoundaryIfNotExist(outboundRequestMsg, contentType);
        }
        HttpUtil.checkAndObserveHttpRequest(dataContext.context, outboundRequestMsg);
        HttpMessageDataStreamer outboundMsgDataStreamer = this.getHttpMessageDataStreamer(outboundRequestMsg);
        HTTPClientConnectorListener httpClientConnectorLister = ObservabilityUtils.isObservabilityEnabled() ? new ObservableHttpClientConnectorListener(dataContext, outboundMsgDataStreamer) : new HTTPClientConnectorListener(dataContext, outboundMsgDataStreamer);
        OutputStream messageOutputStream = outboundMsgDataStreamer.getOutputStream();
        HttpResponseFuture future = clientConnector.send(outboundRequestMsg);
        if (async) {
            future.setResponseHandleListener((HttpClientConnectorListener)httpClientConnectorLister);
        } else {
            future.setHttpConnectorListener((HttpConnectorListener)httpClientConnectorLister);
        }
        try {
            if (boundaryString != null) {
                this.serializeMultiparts(dataContext.context, messageOutputStream, boundaryString);
            } else {
                this.serializeDataSource(dataContext.context, messageOutputStream);
            }
        }
        catch (EncoderException | IOException serializerException) {
            logger.warn("couldn't serialize the message", serializerException);
        }
    }

    private HttpMessageDataStreamer getHttpMessageDataStreamer(HTTPCarbonMessage outboundRequestMsg) {
        PooledDataStreamerFactory pooledDataStreamerFactory = (PooledDataStreamerFactory)outboundRequestMsg.getProperty("POOLED_BYTE_BUFFER_FACTORY");
        HttpMessageDataStreamer outboundMsgDataStreamer = pooledDataStreamerFactory != null ? pooledDataStreamerFactory.createHttpDataStreamer(outboundRequestMsg) : new HttpMessageDataStreamer(outboundRequestMsg);
        return outboundMsgDataStreamer;
    }

    private void serializeMultiparts(Context context, OutputStream messageOutputStream, String boundaryString) throws IOException {
        BStruct entityStruct = this.getEntityStruct(context);
        if (entityStruct != null) {
            BRefValueArray bodyParts = EntityBodyHandler.getBodyPartArray((BStruct)entityStruct);
            if (bodyParts != null && bodyParts.size() > 0L) {
                this.serializeMultipartDataSource(messageOutputStream, boundaryString, entityStruct);
            } else {
                this.serializeDataSource(context, messageOutputStream);
            }
        }
    }

    private BStruct getEntityStruct(Context context) {
        BStruct requestStruct = (BStruct)context.getRefArgument(1);
        return requestStruct.getNativeData("message_entity") != null ? (BStruct)requestStruct.getNativeData("message_entity") : null;
    }

    private void serializeMultipartDataSource(OutputStream messageOutputStream, String boundaryString, BStruct entityStruct) {
        MultipartDataSource multipartDataSource = new MultipartDataSource(entityStruct, boundaryString);
        multipartDataSource.serializeData(messageOutputStream);
        HttpUtil.closeMessageOutputStream(messageOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeDataSource(Context context, OutputStream messageOutputStream) throws IOException {
        BStruct requestStruct = (BStruct)context.getNullableRefArgument(1);
        if (requestStruct == null) {
            return;
        }
        BStruct entityStruct = MimeUtil.extractEntity((BStruct)requestStruct);
        if (entityStruct != null) {
            MessageDataSource messageDataSource = EntityBodyHandler.getMessageDataSource((BStruct)entityStruct);
            if (messageDataSource != null) {
                messageDataSource.serializeData(messageOutputStream);
                HttpUtil.closeMessageOutputStream(messageOutputStream);
            } else if (EntityBodyHandler.getByteChannel((BStruct)entityStruct) != null) {
                try {
                    EntityBodyHandler.writeByteChannelToOutputStream((BStruct)entityStruct, (OutputStream)messageOutputStream);
                }
                finally {
                    HttpUtil.closeMessageOutputStream(messageOutputStream);
                }
            }
        }
    }

    public boolean isBlocking() {
        return false;
    }

    protected BStruct createStruct(Context context, String structName, String protocolPackage) {
        PackageInfo httpPackageInfo = context.getProgramFile().getPackageInfo(protocolPackage);
        StructInfo structInfo = httpPackageInfo.getStructInfo(structName);
        BStructType structType = structInfo.getType();
        return new BStruct(structType);
    }

    BStruct createResponseStruct(Context context, HTTPCarbonMessage httpCarbonMessage) {
        BStruct responseStruct = this.createStruct(context, "Response", "ballerina.http");
        BStruct entity = this.createStruct(context, "Entity", "ballerina.mime");
        BStruct mediaType = this.createStruct(context, "MediaType", "ballerina.mime");
        ResponseCacheControlStruct responseCacheControl = new ResponseCacheControlStruct(context.getProgramFile().getPackageInfo("ballerina.http").getStructInfo("ResponseCacheControl"));
        HttpUtil.populateInboundResponse(responseStruct, entity, mediaType, responseCacheControl, httpCarbonMessage);
        return responseStruct;
    }

    private class ObservableHttpClientConnectorListener
    extends HTTPClientConnectorListener {
        private final Context context;

        private ObservableHttpClientConnectorListener(DataContext dataContext, HttpMessageDataStreamer outboundMsgDataStreamer) {
            super(dataContext, outboundMsgDataStreamer);
            this.context = dataContext.context;
        }

        @Override
        public void onMessage(HTTPCarbonMessage httpCarbonMessage) {
            super.onMessage(httpCarbonMessage);
            Integer statusCode = (Integer)httpCarbonMessage.getProperty("HTTP_STATUS_CODE");
            this.addHttpStatusCode(statusCode != null ? statusCode : 0);
        }

        @Override
        public void onError(Throwable throwable) {
            super.onError(throwable);
            if (throwable instanceof ClientConnectorException) {
                ClientConnectorException clientConnectorException = (ClientConnectorException)throwable;
                this.addHttpStatusCode(clientConnectorException.getHttpStatusCode());
            }
        }

        private void addHttpStatusCode(int statusCode) {
            Optional observerContext = ObservabilityUtils.getParentContext((Context)this.context);
            observerContext.ifPresent(ctx -> ctx.addTag("http.status_code", String.valueOf(statusCode)));
        }
    }

    private class HTTPClientConnectorListener
    implements HttpClientConnectorListener {
        private DataContext dataContext;
        private HttpMessageDataStreamer outboundMsgDataStreamer;

        private HTTPClientConnectorListener(DataContext dataContext, HttpMessageDataStreamer outboundMsgDataStreamer) {
            this.dataContext = dataContext;
            this.outboundMsgDataStreamer = outboundMsgDataStreamer;
        }

        public void onMessage(HTTPCarbonMessage httpCarbonMessage) {
            this.outboundMsgDataStreamer.setIoException(new IOException("Response message already received"));
            this.dataContext.notifyReply(AbstractHTTPAction.this.createResponseStruct(this.dataContext.context, httpCarbonMessage), null);
        }

        public void onResponseHandle(ResponseHandle responseHandle) {
            BStruct httpFuture = AbstractHTTPAction.this.createStruct(this.dataContext.context, "HttpFuture", "ballerina.http");
            httpFuture.addNativeData("transport_handle", (Object)responseHandle);
            this.dataContext.notifyReply(httpFuture, null);
        }

        public void onError(Throwable throwable) {
            BStruct httpConnectorError;
            if (throwable instanceof EndpointTimeOutException) {
                httpConnectorError = AbstractHTTPAction.this.createStruct(this.dataContext.context, "HttpTimeoutError", "ballerina.http");
            } else if (throwable instanceof IOException) {
                this.outboundMsgDataStreamer.setIoException((IOException)throwable);
                httpConnectorError = AbstractHTTPAction.this.createStruct(this.dataContext.context, "HttpConnectorError", "ballerina.http");
            } else {
                this.outboundMsgDataStreamer.setIoException(new IOException(throwable.getMessage()));
                httpConnectorError = AbstractHTTPAction.this.createStruct(this.dataContext.context, "HttpConnectorError", "ballerina.http");
            }
            httpConnectorError.setStringField(0, throwable.getMessage());
            if (throwable instanceof ClientConnectorException) {
                ClientConnectorException clientConnectorException = (ClientConnectorException)throwable;
                httpConnectorError.setIntField(0, (long)clientConnectorException.getHttpStatusCode());
            }
            this.dataContext.notifyReply(null, httpConnectorError);
        }
    }
}

