/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Locale;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.actions.httpclient.AbstractHTTPAction;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.contract.ClientConnectorException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="execute", receiver=@Receiver(type=TypeKind.STRUCT, structType="CallerActions", structPackage="ballerina.http"), args={@Argument(name="client", type=TypeKind.STRUCT), @Argument(name="httpVerb", type=TypeKind.STRING), @Argument(name="path", type=TypeKind.STRING), @Argument(name="req", type=TypeKind.STRUCT, structType="Request", structPackage="ballerina.http")}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="Response", structPackage="ballerina.http"), @ReturnType(type=TypeKind.STRUCT, structType="HttpConnectorError", structPackage="ballerina.http")})
public class Execute
extends AbstractHTTPAction {
    public void execute(Context context, CallableUnitCallback callback) {
        DataContext dataContext = new DataContext(context, callback, this.createOutboundRequestMsg(context));
        try {
            this.executeNonBlockingAction(dataContext);
        }
        catch (ClientConnectorException clientConnectorException) {
            BallerinaException exception = new BallerinaException("Failed to invoke 'execute' action in CallerActions. " + clientConnectorException.getMessage(), context);
            dataContext.notifyReply(null, HttpUtil.getHttpConnectorError(context, exception));
        }
    }

    @Override
    protected HTTPCarbonMessage createOutboundRequestMsg(Context context) {
        BStruct bConnector = (BStruct)context.getRefArgument(0);
        String httpVerb = context.getStringArgument(0);
        String path = context.getStringArgument(1);
        BStruct requestStruct = (BStruct)context.getRefArgument(1);
        HTTPCarbonMessage defaultCarbonMsg = HttpUtil.createHttpCarbonMessage(true);
        HTTPCarbonMessage outboundRequestMsg = HttpUtil.getCarbonMsg(requestStruct, defaultCarbonMsg);
        this.prepareOutboundRequest(context, bConnector, path, outboundRequestMsg);
        if (httpVerb == null || "".equals(httpVerb)) {
            httpVerb = (String)outboundRequestMsg.getProperty("HTTP_METHOD");
        }
        outboundRequestMsg.setProperty("HTTP_METHOD", (Object)httpVerb.trim().toUpperCase(Locale.getDefault()));
        if (outboundRequestMsg.getHeader(HttpHeaderNames.ACCEPT_ENCODING.toString()) == null) {
            outboundRequestMsg.setHeader(HttpHeaderNames.ACCEPT_ENCODING.toString(), "deflate, gzip");
        }
        return outboundRequestMsg;
    }
}

