/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import java.util.Locale;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.actions.httpclient.AbstractHTTPAction;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.contract.ClientConnectorException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="forward", receiver=@Receiver(type=TypeKind.STRUCT, structType="CallerActions", structPackage="ballerina.http"), args={@Argument(name="client", type=TypeKind.STRUCT), @Argument(name="path", type=TypeKind.STRING), @Argument(name="req", type=TypeKind.STRUCT, structType="Request", structPackage="ballerina.http")}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="Response", structPackage="ballerina.http"), @ReturnType(type=TypeKind.STRUCT, structType="HttpConnectorError", structPackage="ballerina.http")})
public class Forward
extends AbstractHTTPAction {
    public void execute(Context context, CallableUnitCallback callback) {
        DataContext dataContext = new DataContext(context, callback, this.createOutboundRequestMsg(context));
        try {
            this.executeNonBlockingAction(dataContext);
        }
        catch (ClientConnectorException clientConnectorException) {
            BallerinaException exception = new BallerinaException("Failed to invoke 'forward' action in CallerActions. " + clientConnectorException.getMessage(), context);
            dataContext.notifyReply(null, HttpUtil.getHttpConnectorError(context, exception));
        }
    }

    @Override
    protected HTTPCarbonMessage createOutboundRequestMsg(Context context) {
        BStruct bConnector = (BStruct)context.getRefArgument(0);
        String path = context.getStringArgument(0);
        BStruct requestStruct = (BStruct)context.getRefArgument(1);
        if (requestStruct.getNativeData("Request") == null && !HttpUtil.isEntityDataSourceAvailble(requestStruct)) {
            throw new BallerinaException("invalid inbound request parameter");
        }
        HTTPCarbonMessage outboundRequestMsg = HttpUtil.getCarbonMsg(requestStruct, HttpUtil.createHttpCarbonMessage(true));
        if (HttpUtil.isEntityDataSourceAvailble(requestStruct)) {
            HttpUtil.enrichOutboundMessage(outboundRequestMsg, requestStruct);
            this.prepareOutboundRequest(context, bConnector, path, outboundRequestMsg);
            outboundRequestMsg.setProperty("HTTP_METHOD", (Object)BLangConnectorSPIUtil.toStruct((BStruct)requestStruct).getStringField("method"));
        } else {
            this.prepareOutboundRequest(context, bConnector, path, outboundRequestMsg);
            String httpVerb = (String)outboundRequestMsg.getProperty("HTTP_METHOD");
            outboundRequestMsg.setProperty("HTTP_METHOD", (Object)httpVerb.trim().toUpperCase(Locale.getDefault()));
        }
        return outboundRequestMsg;
    }
}

