/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.actions.httpclient.AbstractHTTPAction;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpClientConnectorListener;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.ResponseHandle;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="getNextPromise", receiver=@Receiver(type=TypeKind.STRUCT, structType="CallerActions", structPackage="ballerina.http"), args={@Argument(name="client", type=TypeKind.STRUCT), @Argument(name="httpFuture", type=TypeKind.STRUCT, structType="HttpFuture", structPackage="ballerina.http")}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="PushPromise", structPackage="ballerina.http"), @ReturnType(type=TypeKind.STRUCT, structType="HttpConnectorError", structPackage="ballerina.http")})
public class GetNextPromise
extends AbstractHTTPAction {
    public void execute(Context context, CallableUnitCallback callback) {
        DataContext dataContext = new DataContext(context, callback, null);
        BStruct handleStruct = (BStruct)context.getRefArgument(1);
        ResponseHandle responseHandle = (ResponseHandle)handleStruct.getNativeData("transport_handle");
        if (responseHandle == null) {
            throw new BallerinaException("invalid http handle");
        }
        BStruct bConnector = (BStruct)context.getRefArgument(0);
        HttpClientConnector clientConnector = (HttpClientConnector)bConnector.getNativeData("CallerActions");
        clientConnector.getNextPushPromise(responseHandle).setPushPromiseListener((HttpConnectorListener)new PromiseListener(dataContext));
    }

    private class PromiseListener
    implements HttpClientConnectorListener {
        private DataContext dataContext;

        PromiseListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        public void onPushPromise(Http2PushPromise pushPromise) {
            BStruct pushPromiseStruct = GetNextPromise.this.createStruct(this.dataContext.context, "PushPromise", "ballerina.http");
            HttpUtil.populatePushPromiseStruct(pushPromiseStruct, pushPromise);
            this.dataContext.notifyReply(pushPromiseStruct, null);
        }
    }
}

