/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.actions.httpclient.AbstractHTTPAction;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.contract.ClientConnectorException;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpClientConnectorListener;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.Http2PushPromise;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="getPromisedResponse", receiver=@Receiver(type=TypeKind.STRUCT, structType="CallerActions", structPackage="ballerina.http"), args={@Argument(name="client", type=TypeKind.STRUCT), @Argument(name="promise", type=TypeKind.STRUCT, structType="PushPromise", structPackage="ballerina.http")}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="InResponse", structPackage="ballerina.http"), @ReturnType(type=TypeKind.STRUCT, structType="HttpConnectorError", structPackage="ballerina.http")})
public class GetPromisedResponse
extends AbstractHTTPAction {
    public void execute(Context context, CallableUnitCallback callback) {
        DataContext dataContext = new DataContext(context, callback, null);
        BStruct pushPromiseStruct = (BStruct)context.getRefArgument(1);
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseStruct, null);
        if (http2PushPromise == null) {
            throw new BallerinaException("invalid push promise");
        }
        BStruct bConnector = (BStruct)context.getRefArgument(0);
        HttpClientConnector clientConnector = (HttpClientConnector)bConnector.getNativeData("CallerActions");
        clientConnector.getPushResponse(http2PushPromise).setPushResponseListener((HttpConnectorListener)new PushResponseListener(dataContext), http2PushPromise.getPromisedStreamId());
    }

    private class PushResponseListener
    implements HttpClientConnectorListener {
        private DataContext dataContext;

        PushResponseListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        public void onPushResponse(int promisedId, HTTPCarbonMessage httpCarbonMessage) {
            this.dataContext.notifyReply(GetPromisedResponse.this.createResponseStruct(this.dataContext.context, httpCarbonMessage), null);
        }

        public void onError(Throwable throwable) {
            BStruct httpConnectorError = GetPromisedResponse.this.createStruct(this.dataContext.context, "HttpConnectorError", "ballerina.http");
            httpConnectorError.setStringField(0, throwable.getMessage());
            if (throwable instanceof ClientConnectorException) {
                ClientConnectorException clientConnectorException = (ClientConnectorException)throwable;
                httpConnectorError.setIntField(0, (long)clientConnectorException.getHttpStatusCode());
            }
            this.dataContext.notifyReply(null, httpConnectorError);
        }
    }
}

