/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.http.actions.httpclient.AbstractHTTPAction;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpClientConnectorListener;
import org.wso2.transport.http.netty.message.ResponseHandle;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="hasPromise", receiver=@Receiver(type=TypeKind.STRUCT, structType="CallerActions", structPackage="ballerina.http"), args={@Argument(name="client", type=TypeKind.STRUCT), @Argument(name="httpFuture", type=TypeKind.STRUCT, structType="HttpFuture", structPackage="ballerina.http")}, returnType={@ReturnType(type=TypeKind.BOOLEAN)})
public class HasPromise
extends AbstractHTTPAction {
    public void execute(Context context, CallableUnitCallback callback) {
        BStruct handleStruct = (BStruct)context.getRefArgument(1);
        ResponseHandle responseHandle = (ResponseHandle)handleStruct.getNativeData("transport_handle");
        if (responseHandle == null) {
            throw new BallerinaException("invalid http handle");
        }
        BStruct bConnector = (BStruct)context.getRefArgument(0);
        HttpClientConnector clientConnector = (HttpClientConnector)bConnector.getNativeData("CallerActions");
        clientConnector.hasPushPromise(responseHandle).setPromiseAvailabilityListener((HttpClientConnectorListener)new PromiseAvailabilityCheckListener(context, callback));
    }

    private static class PromiseAvailabilityCheckListener
    implements HttpClientConnectorListener {
        private Context context;
        private CallableUnitCallback callback;

        PromiseAvailabilityCheckListener(Context context, CallableUnitCallback callback) {
            this.context = context;
            this.callback = callback;
        }

        public void onPushPromiseAvailability(boolean isPromiseAvailable) {
            this.context.setReturnValues(new BValue[]{new BBoolean(isPromiseAvailable)});
            this.callback.notifySuccess();
        }
    }
}

