/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.websocketconnector;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Set;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.http.WebSocketConnectionManager;
import org.ballerinalang.net.http.WebSocketService;
import org.ballerinalang.net.http.WebSocketUtil;
import org.wso2.transport.http.netty.contract.websocket.WebSocketInitMessage;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="acceptWebSocketUpgrade", receiver=@Receiver(type=TypeKind.STRUCT, structType="Connection", structPackage="ballerina.http"), args={@Argument(name="headers", type=TypeKind.MAP)}, isPublic=true)
public class AcceptWebSocketUpgrade
implements NativeCallableUnit {
    public void execute(Context context, CallableUnitCallback callback) {
        BStruct httpConnection = (BStruct)context.getRefArgument(0);
        WebSocketInitMessage initMessage = (WebSocketInitMessage)httpConnection.getNativeData("WEBSOCKET_MESSAGE");
        WebSocketConnectionManager connectionManager = (WebSocketConnectionManager)httpConnection.getNativeData("WEBSOCKET_CONNECTION_MANAGER");
        if (initMessage == null) {
            throw new BallerinaConnectorException("Not a WebSocket upgrade request. Cannot upgrade from HTTP to WS");
        }
        if (connectionManager == null) {
            throw new BallerinaConnectorException("Cannot accept a WebSocket upgrade without WebSocket connection manager");
        }
        WebSocketService webSocketService = (WebSocketService)httpConnection.getNativeData("WebSocketService");
        BMap headers = (BMap)context.getRefArgument(1);
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        Set keys = headers.keySet();
        for (String key : keys) {
            httpHeaders.add(key, (Object)headers.get((Object)key));
        }
        WebSocketUtil.handleHandshake(webSocketService, connectionManager, (HttpHeaders)httpHeaders, initMessage, context, callback);
    }

    public boolean isBlocking() {
        return false;
    }
}

