/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.websocketconnector;

import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.http.WebSocketConnectionManager;
import org.ballerinalang.net.http.WebSocketUtil;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="close", receiver=@Receiver(type=TypeKind.STRUCT, structType="WebSocketConnector", structPackage="ballerina.http"), args={@Argument(name="wsConnector", type=TypeKind.STRUCT), @Argument(name="statusCode", type=TypeKind.INT), @Argument(name="reason", type=TypeKind.STRING)})
public class Close
implements NativeCallableUnit {
    public void execute(Context context, CallableUnitCallback callback) {
        try {
            BStruct webSocketConnector = (BStruct)context.getRefArgument(0);
            int statusCode = (int)context.getIntArgument(0);
            String reason = context.getStringArgument(0);
            WebSocketConnection webSocketConnection = (WebSocketConnection)webSocketConnector.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION");
            webSocketConnection.close(statusCode, reason).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                Throwable cause = future.cause();
                if (!future.isSuccess() && cause != null) {
                    context.setReturnValues(new BValue[]{WebSocketUtil.createWebSocketConnectorError(context, future.cause().getMessage())});
                } else {
                    context.setReturnValues(new BValue[0]);
                }
                callback.notifySuccess();
                WebSocketConnectionManager connectionManager = (WebSocketConnectionManager)webSocketConnector.getNativeData("WEBSOCKET_CONNECTION_MANAGER");
                if (connectionManager != null) {
                    connectionManager.removeConnectionInfo(webSocketConnection.getId());
                }
            }));
        }
        catch (Throwable throwable) {
            context.setReturnValues(new BValue[]{WebSocketUtil.createWebSocketConnectorError(context, throwable.getMessage())});
            callback.notifySuccess();
        }
    }

    public boolean isBlocking() {
        return false;
    }
}

