/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.websocketconnector;

import io.netty.channel.ChannelFuture;
import java.nio.ByteBuffer;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.http.WebSocketUtil;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="pushBinary", receiver=@Receiver(type=TypeKind.STRUCT, structType="WebSocketConnector", structPackage="ballerina.http"), args={@Argument(name="wsConnector", type=TypeKind.STRUCT), @Argument(name="data", type=TypeKind.BLOB), @Argument(name="final", type=TypeKind.BOOLEAN)})
public class PushBinary
implements NativeCallableUnit {
    public void execute(Context context, CallableUnitCallback callback) {
        try {
            BStruct wsConnection = (BStruct)context.getRefArgument(0);
            WebSocketConnection webSocketConnection = (WebSocketConnection)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION");
            byte[] binaryData = context.getBlobArgument(0);
            boolean finalFrame = context.getBooleanArgument(0);
            ChannelFuture webSocketChannelFuture = webSocketConnection.pushBinary(ByteBuffer.wrap(binaryData), finalFrame);
            WebSocketUtil.handleWebSocketCallback(context, callback, webSocketChannelFuture);
        }
        catch (Throwable throwable) {
            context.setReturnValues(new BValue[]{WebSocketUtil.createWebSocketConnectorError(context, throwable.getMessage())});
            callback.notifySuccess();
        }
    }

    public boolean isBlocking() {
        return false;
    }
}

