/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.caching;

import java.util.Map;
import org.ballerinalang.bre.bvm.BLangVMStructs;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.net.http.caching.CacheControlDirective;
import org.ballerinalang.net.http.caching.CacheControlParser;
import org.ballerinalang.util.codegen.StructInfo;

public class RequestCacheControlStruct {
    private BStruct requestCacheControl;

    public RequestCacheControlStruct(StructInfo structInfo) {
        this.requestCacheControl = BLangVMStructs.createBStruct((StructInfo)structInfo, (Object[])new Object[0]);
        this.requestCacheControl.setBooleanField(2, 1);
        this.requestCacheControl.setIntField(0, -1L);
        this.requestCacheControl.setIntField(1, -1L);
        this.requestCacheControl.setIntField(2, -1L);
    }

    public RequestCacheControlStruct(BStruct requestCacheControl) {
        this.requestCacheControl = requestCacheControl;
        requestCacheControl.setBooleanField(2, 1);
        requestCacheControl.setIntField(0, -1L);
        requestCacheControl.setIntField(1, -1L);
        requestCacheControl.setIntField(2, -1L);
    }

    public BStruct getStruct() {
        return this.requestCacheControl;
    }

    public RequestCacheControlStruct setNoCache(boolean noCache) {
        this.requestCacheControl.setBooleanField(0, noCache ? 1 : 0);
        return this;
    }

    public RequestCacheControlStruct setNoStore(boolean noStore) {
        this.requestCacheControl.setBooleanField(1, noStore ? 1 : 0);
        return this;
    }

    public RequestCacheControlStruct setNoTransform(boolean noTransform) {
        this.requestCacheControl.setBooleanField(2, noTransform ? 1 : 0);
        return this;
    }

    public RequestCacheControlStruct setOnlyIfCached(boolean onlyIfCached) {
        this.requestCacheControl.setBooleanField(3, onlyIfCached ? 1 : 0);
        return this;
    }

    public RequestCacheControlStruct setMaxAge(long maxAge) {
        this.requestCacheControl.setIntField(0, maxAge);
        return this;
    }

    public RequestCacheControlStruct setMaxStale(long maxStale) {
        this.requestCacheControl.setIntField(1, maxStale);
        return this;
    }

    public RequestCacheControlStruct setMinFresh(long minFresh) {
        this.requestCacheControl.setIntField(2, minFresh);
        return this;
    }

    public void populateStruct(String cacheControlHeaderVal) {
        Map<CacheControlDirective, String> controlDirectives = CacheControlParser.parse(cacheControlHeaderVal);
        controlDirectives.forEach((directive, value) -> {
            switch (directive) {
                case NO_CACHE: {
                    this.requestCacheControl.setBooleanField(0, 1);
                    break;
                }
                case NO_STORE: {
                    this.requestCacheControl.setBooleanField(1, 1);
                    break;
                }
                case NO_TRANSFORM: {
                    this.requestCacheControl.setBooleanField(2, 1);
                    break;
                }
                case ONLY_IF_CACHED: {
                    this.requestCacheControl.setBooleanField(3, 1);
                    break;
                }
                case MAX_AGE: {
                    this.requestCacheControl.setIntField(0, Long.parseLong(value));
                    break;
                }
                case MAX_STALE: {
                    this.requestCacheControl.setIntField(1, Long.parseLong(value));
                    break;
                }
                case MIN_FRESH: {
                    this.requestCacheControl.setIntField(2, Long.parseLong(value));
                    break;
                }
            }
        });
    }
}

