/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.caching;

import java.util.Map;
import java.util.StringJoiner;
import org.ballerinalang.bre.bvm.BLangVMStructs;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.net.http.caching.CacheControlDirective;
import org.ballerinalang.net.http.caching.CacheControlParser;
import org.ballerinalang.util.codegen.StructInfo;

public class ResponseCacheControlStruct {
    private BStruct responseCacheControl;

    public ResponseCacheControlStruct(StructInfo structInfo) {
        this.responseCacheControl = BLangVMStructs.createBStruct((StructInfo)structInfo, (Object[])new Object[0]);
        this.init();
    }

    public ResponseCacheControlStruct(BStruct responseCacheControl) {
        this.responseCacheControl = responseCacheControl;
    }

    public BStruct getStruct() {
        return this.responseCacheControl;
    }

    public void setStruct(BStruct responseCacheControl) {
        this.responseCacheControl = responseCacheControl;
    }

    public void init() {
        this.responseCacheControl.setBooleanField(3, 1);
        this.responseCacheControl.setIntField(0, -1L);
        this.responseCacheControl.setIntField(1, -1L);
    }

    public ResponseCacheControlStruct setMustRevalidate(boolean mustRevalidate) {
        this.responseCacheControl.setBooleanField(0, mustRevalidate ? 1 : 0);
        return this;
    }

    public ResponseCacheControlStruct setNoCache(boolean noCache) {
        this.responseCacheControl.setBooleanField(1, noCache ? 1 : 0);
        return this;
    }

    public ResponseCacheControlStruct setNoCache(boolean noCache, String[] noCacheFields) {
        this.responseCacheControl.setBooleanField(1, noCache ? 1 : 0);
        this.responseCacheControl.setRefField(0, (BRefType)new BStringArray(noCacheFields));
        return this;
    }

    public ResponseCacheControlStruct setNoStore(boolean noStore) {
        this.responseCacheControl.setBooleanField(2, noStore ? 1 : 0);
        return this;
    }

    public ResponseCacheControlStruct setNoTransform(boolean noTransform) {
        this.responseCacheControl.setBooleanField(3, noTransform ? 1 : 0);
        return this;
    }

    public ResponseCacheControlStruct setPrivate(boolean isPrivate) {
        this.responseCacheControl.setBooleanField(4, isPrivate ? 1 : 0);
        return this;
    }

    public ResponseCacheControlStruct setPrivate(boolean isPrivate, String[] privateFields) {
        this.responseCacheControl.setBooleanField(4, isPrivate ? 1 : 0);
        this.responseCacheControl.setRefField(1, (BRefType)new BStringArray(privateFields));
        return this;
    }

    public ResponseCacheControlStruct setProxyRevalidate(boolean proxyRevalidate) {
        this.responseCacheControl.setBooleanField(5, proxyRevalidate ? 1 : 0);
        return this;
    }

    public ResponseCacheControlStruct setMaxAge(long maxAge) {
        this.responseCacheControl.setIntField(0, maxAge);
        return this;
    }

    public ResponseCacheControlStruct setSMaxAge(long sMaxAge) {
        this.responseCacheControl.setIntField(1, sMaxAge);
        return this;
    }

    public void populateStruct(String cacheControlHeaderVal) {
        Map<CacheControlDirective, String> controlDirectives = CacheControlParser.parse(cacheControlHeaderVal);
        controlDirectives.forEach((directive, value) -> {
            switch (directive) {
                case MUST_REVALIDATE: {
                    this.responseCacheControl.setBooleanField(0, 1);
                    break;
                }
                case NO_CACHE: {
                    this.responseCacheControl.setBooleanField(1, 1);
                    if (value == null) break;
                    value = value.replace("\"", "");
                    this.responseCacheControl.setRefField(0, (BRefType)new BStringArray(value.split(",")));
                    break;
                }
                case NO_STORE: {
                    this.responseCacheControl.setBooleanField(2, 1);
                    break;
                }
                case NO_TRANSFORM: {
                    this.responseCacheControl.setBooleanField(3, 1);
                    break;
                }
                case PRIVATE: {
                    this.responseCacheControl.setBooleanField(4, 1);
                    if (value == null) break;
                    value = value.replace("\"", "");
                    this.responseCacheControl.setRefField(1, (BRefType)new BStringArray(value.split(",")));
                    break;
                }
                case PUBLIC: {
                    this.responseCacheControl.setBooleanField(4, 0);
                    break;
                }
                case PROXY_REVALIDATE: {
                    this.responseCacheControl.setBooleanField(5, 1);
                    break;
                }
                case MAX_AGE: {
                    this.responseCacheControl.setIntField(0, Long.parseLong(value));
                    break;
                }
                case S_MAXAGE: {
                    this.responseCacheControl.setIntField(1, Long.parseLong(value));
                    break;
                }
            }
        });
    }

    public String buildCacheControlDirectives() {
        StringJoiner directivesBuilder = new StringJoiner(",");
        if (this.responseCacheControl.getBooleanField(0) == 1) {
            directivesBuilder.add("must-revalidate");
        }
        if (this.responseCacheControl.getBooleanField(1) == 1) {
            directivesBuilder.add("no-cache" + this.appendFields((BStringArray)this.responseCacheControl.getRefField(0)));
        }
        if (this.responseCacheControl.getBooleanField(2) == 1) {
            directivesBuilder.add("no-store");
        }
        if (this.responseCacheControl.getBooleanField(3) == 1) {
            directivesBuilder.add("no-transform");
        }
        if (this.responseCacheControl.getBooleanField(4) == 1) {
            directivesBuilder.add("private" + this.appendFields((BStringArray)this.responseCacheControl.getRefField(1)));
        } else {
            directivesBuilder.add("public");
        }
        if (this.responseCacheControl.getBooleanField(5) == 1) {
            directivesBuilder.add("proxy-revalidate");
        }
        if (this.responseCacheControl.getIntField(0) >= 0L) {
            directivesBuilder.add("max-age=" + this.responseCacheControl.getIntField(0));
        }
        if (this.responseCacheControl.getIntField(1) >= 0L) {
            directivesBuilder.add("s-maxage=" + this.responseCacheControl.getIntField(1));
        }
        return directivesBuilder.toString();
    }

    private String appendFields(BStringArray values) {
        if (values.size() > 0L) {
            StringJoiner joiner = new StringJoiner(",");
            int i = 0;
            while ((long)i < values.size()) {
                joiner.add(values.get((long)i));
                ++i;
            }
            return "=\"" + joiner.toString() + "\"";
        }
        return "";
    }
}

