/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.clientendpoint;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.net.http.HttpConnectionManager;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.common.ProxyServerConfiguration;
import org.wso2.transport.http.netty.config.Parameter;
import org.wso2.transport.http.netty.config.SenderConfiguration;
import org.wso2.transport.http.netty.config.TransportsConfiguration;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpWsConnectorFactory;
import org.wso2.transport.http.netty.message.HTTPConnectorUtil;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="createHttpClient", args={@Argument(name="uri", type=TypeKind.STRING), @Argument(name="config", type=TypeKind.STRUCT, structType="ClientEndpointConfig")}, isPublic=true)
public class CreateHttpClient
extends BlockingNativeCallableUnit {
    private static final int DEFAULT_MAX_REDIRECT_COUNT = 5;
    private HttpWsConnectorFactory httpConnectorFactory = HttpUtil.createHttpWsConnectionFactory();

    public void execute(Context context) {
        URL url;
        BStruct configBStruct = (BStruct)context.getRefArgument(0);
        Struct clientEndpointConfig = BLangConnectorSPIUtil.toStruct((BStruct)configBStruct);
        String urlString = context.getStringArgument(0);
        HttpConnectionManager connectionManager = HttpConnectionManager.getInstance();
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new BallerinaException("Malformed URL: " + urlString);
        }
        String scheme = url.getProtocol();
        Map properties = HTTPConnectorUtil.getTransportProperties((TransportsConfiguration)connectionManager.getTransportConfig());
        SenderConfiguration senderConfiguration = HTTPConnectorUtil.getSenderConfiguration((TransportsConfiguration)connectionManager.getTransportConfig(), (String)scheme);
        if (connectionManager.isHTTPTraceLoggerEnabled()) {
            senderConfiguration.setHttpTraceLogEnabled(true);
        }
        senderConfiguration.setTLSStoreType("PKCS12");
        this.populateSenderConfigurationOptions(senderConfiguration, clientEndpointConfig);
        Struct connectionThrottling = clientEndpointConfig.getStructField("connectionThrottling");
        if (connectionThrottling != null) {
            long maxActiveConnections = connectionThrottling.getIntField("maxActiveConnections");
            if (!this.isInteger(maxActiveConnections)) {
                throw new BallerinaConnectorException("invalid maxActiveConnections value: " + maxActiveConnections);
            }
            senderConfiguration.getPoolConfiguration().setMaxActivePerPool((int)maxActiveConnections);
            long maxActiveStreamsPerConnection = connectionThrottling.getIntField("maxActiveStreamsPerConnection");
            if (!this.isInteger(maxActiveStreamsPerConnection)) {
                throw new BallerinaConnectorException("invalid maxActiveStreamsPerConnection value: " + maxActiveStreamsPerConnection);
            }
            senderConfiguration.getPoolConfiguration().setHttp2MaxActiveStreamsPerConnection(maxActiveStreamsPerConnection == -1L ? Integer.MAX_VALUE : (int)maxActiveStreamsPerConnection);
            long waitTime = connectionThrottling.getIntField("waitTime");
            senderConfiguration.getPoolConfiguration().setMaxWaitTime(waitTime);
        }
        HttpClientConnector httpClientConnector = this.httpConnectorFactory.createHttpClientConnector(properties, senderConfiguration);
        BStruct httpClient = BLangConnectorSPIUtil.createBStruct((ProgramFile)context.getProgramFile(), (String)"ballerina.http", (String)"CallerActions", (Object[])new Object[]{urlString, clientEndpointConfig});
        httpClient.addNativeData("CallerActions", (Object)httpClientConnector);
        httpClient.addNativeData("config", (Object)clientEndpointConfig);
        context.setReturnValues(new BValue[]{httpClient});
    }

    private void populateSenderConfigurationOptions(SenderConfiguration senderConfiguration, Struct clientEndpointConfig) {
        Value[] targetServices;
        ProxyServerConfiguration proxyServerConfiguration = null;
        boolean followRedirect = false;
        int maxRedirectCount = 5;
        Struct followRedirects = clientEndpointConfig.getStructField("followRedirects");
        if (followRedirects != null) {
            followRedirect = followRedirects.getBooleanField("enabled");
            maxRedirectCount = (int)followRedirects.getIntField("maxCount");
        }
        Struct secureSocket = null;
        for (Value targetService : targetServices = clientEndpointConfig.getArrayField("targets")) {
            secureSocket = targetService.getStructValue().getStructField("secureSocket");
            if (secureSocket == null) continue;
            Struct trustStore = secureSocket.getStructField("trustStore");
            Struct keyStore = secureSocket.getStructField("keyStore");
            Struct protocols = secureSocket.getStructField("protocol");
            Struct validateCert = secureSocket.getStructField("certValidation");
            ArrayList<Parameter> clientParams = new ArrayList<Parameter>();
            if (trustStore != null) {
                String trustStorePassword;
                String trustStoreFile = trustStore.getStringField("path");
                if (StringUtils.isNotBlank((CharSequence)trustStoreFile)) {
                    senderConfiguration.setTrustStoreFile(trustStoreFile);
                }
                if (StringUtils.isNotBlank((CharSequence)(trustStorePassword = trustStore.getStringField("password")))) {
                    senderConfiguration.setTrustStorePass(trustStorePassword);
                }
            }
            if (keyStore != null) {
                String keyStorePassword;
                String keyStoreFile = keyStore.getStringField("path");
                if (StringUtils.isNotBlank((CharSequence)keyStoreFile)) {
                    senderConfiguration.setKeyStoreFile(keyStoreFile);
                }
                if (StringUtils.isNotBlank((CharSequence)(keyStorePassword = keyStore.getStringField("password")))) {
                    senderConfiguration.setKeyStorePassword(keyStorePassword);
                }
            }
            if (protocols != null) {
                String sslProtocol;
                List<Value> sslEnabledProtocolsValueList = Arrays.asList(protocols.getArrayField("versions"));
                if (sslEnabledProtocolsValueList.size() > 0) {
                    String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().map(Value::getStringValue).collect(Collectors.joining(",", "", ""));
                    Parameter clientProtocols = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
                    clientParams.add(clientProtocols);
                }
                if (StringUtils.isNotBlank((CharSequence)(sslProtocol = protocols.getStringField("name")))) {
                    senderConfiguration.setSSLProtocol(sslProtocol);
                }
            }
            if (validateCert != null) {
                boolean validateCertEnabled = validateCert.getBooleanField("enable");
                int cacheSize = (int)validateCert.getIntField("cacheSize");
                int cacheValidityPeriod = (int)validateCert.getIntField("cacheValidityPeriod");
                senderConfiguration.setValidateCertEnabled(validateCertEnabled);
                if (cacheValidityPeriod != 0) {
                    senderConfiguration.setCacheValidityPeriod(cacheValidityPeriod);
                }
                if (cacheSize != 0) {
                    senderConfiguration.setCacheSize(cacheSize);
                }
            }
            boolean hostNameVerificationEnabled = secureSocket.getBooleanField("verifyHostname");
            boolean ocspStaplingEnabled = secureSocket.getBooleanField("ocspStapling");
            senderConfiguration.setOcspStaplingEnabled(ocspStaplingEnabled);
            senderConfiguration.setHostNameVerificationEnabled(hostNameVerificationEnabled);
            List<Value> ciphersValueList = Arrays.asList(secureSocket.getArrayField("ciphers"));
            if (ciphersValueList.size() > 0) {
                String ciphers = ciphersValueList.stream().map(Value::getStringValue).collect(Collectors.joining(",", "", ""));
                Parameter clientCiphers = new Parameter("ciphers", ciphers);
                clientParams.add(clientCiphers);
            }
            String enableSessionCreation = String.valueOf(secureSocket.getBooleanField("shareSession"));
            Parameter clientEnableSessionCreation = new Parameter("shareSession", enableSessionCreation);
            clientParams.add(clientEnableSessionCreation);
            if (clientParams.isEmpty()) continue;
            senderConfiguration.setParameters(clientParams);
        }
        Struct proxy = clientEndpointConfig.getStructField("proxy");
        if (proxy != null) {
            String proxyHost = proxy.getStringField("host");
            int proxyPort = (int)proxy.getIntField("port");
            String proxyUserName = proxy.getStringField("userName");
            String proxyPassword = proxy.getStringField("password");
            try {
                proxyServerConfiguration = new ProxyServerConfiguration(proxyHost, proxyPort);
            }
            catch (UnknownHostException e) {
                throw new BallerinaConnectorException("Failed to resolve host" + proxyHost, (Throwable)e);
            }
            if (!proxyUserName.isEmpty()) {
                proxyServerConfiguration.setProxyUsername(proxyUserName);
            }
            if (!proxyPassword.isEmpty()) {
                proxyServerConfiguration.setProxyPassword(proxyPassword);
            }
            senderConfiguration.setProxyServerConfiguration(proxyServerConfiguration);
        }
        senderConfiguration.setFollowRedirect(followRedirect);
        senderConfiguration.setMaxRedirectCount(maxRedirectCount);
        String transferEncoding = clientEndpointConfig.getRefField("transferEncoding").getStringValue();
        if (transferEncoding != null && !"chunking".equalsIgnoreCase(transferEncoding)) {
            throw new BallerinaConnectorException("Unsupported configuration found for Transfer-Encoding : " + transferEncoding);
        }
        String chunking = clientEndpointConfig.getRefField("chunking").getStringValue();
        senderConfiguration.setChunkingConfig(HttpUtil.getChunkConfig(chunking));
        long timeoutMillis = clientEndpointConfig.getIntField("timeoutMillis");
        if (timeoutMillis < 0L || !this.isInteger(timeoutMillis)) {
            throw new BallerinaConnectorException("invalid idle timeout: " + timeoutMillis);
        }
        senderConfiguration.setSocketIdleTimeout((int)timeoutMillis);
        String keepAliveConfig = clientEndpointConfig.getRefField("keepAlive").getStringValue();
        senderConfiguration.setKeepAliveConfig(HttpUtil.getKeepAliveConfig(keepAliveConfig));
        String httpVersion = clientEndpointConfig.getStringField("httpVersion");
        if (httpVersion != null) {
            senderConfiguration.setHttpVersion(httpVersion);
        }
        String forwardedExtension = clientEndpointConfig.getStringField("forwarded");
        senderConfiguration.setForwardedExtensionConfig(HttpUtil.getForwardedExtensionConfig(forwardedExtension));
    }

    private boolean isInteger(long val) {
        return (long)((int)val) == val;
    }
}

