/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.compiler;

import java.util.List;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportEndpointTypes;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.EndpointNode;
import org.ballerinalang.model.tree.ResourceNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.types.UserDefinedTypeNode;
import org.ballerinalang.net.http.compiler.ResourceSignatureValidator;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;

@SupportEndpointTypes(value={@SupportEndpointTypes.EndpointType(orgName="ballerina", packageName="http", name="Listener")})
public class HttpServiceCompilerPlugin
extends AbstractCompilerPlugin {
    private DiagnosticLog dlog = null;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        for (AnnotationAttachmentNode annotation : annotations) {
            if (!annotation.getAnnotationName().getValue().equals("ServiceConfig")) continue;
            this.handleServiceConfigAnnotation(serviceNode, (BLangAnnotationAttachment)annotation);
        }
        UserDefinedTypeNode serviceType = serviceNode.getServiceTypeStruct();
        if (serviceType != null && "Service".equals(serviceType.getTypeName().getValue())) {
            List resources = serviceNode.getResources();
            resources.forEach(res -> {
                ResourceSignatureValidator.validateAnnotation((ResourceNode)res, this.dlog);
                ResourceSignatureValidator.validate(res.getParameters(), this.dlog, res.pos);
            });
        }
    }

    public void process(EndpointNode endpointNode, List<AnnotationAttachmentNode> annotations) {
    }

    private void handleServiceConfigAnnotation(ServiceNode serviceNode, BLangAnnotationAttachment annotation) {
    }
}

