/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.compiler;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ResourceNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class ResourceSignatureValidator {
    public static final int COMPULSORY_PARAM_COUNT = 2;
    private static final String ENDPOINT_TYPE = "ballerina.http:Listener";
    private static final String HTTP_REQUEST_TYPE = "ballerina.http:Request";

    public static void validate(List<BLangVariable> signatureParams, DiagnosticLog dlog, DiagnosticPos pos) {
        int nParams = signatureParams.size();
        if (nParams < 2) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"resource signature parameter count should be >= 2");
            return;
        }
        if (!ResourceSignatureValidator.isValidResourceParam(signatureParams.get(0), ENDPOINT_TYPE)) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"first parameter should be of type ballerina.http:Listener");
            return;
        }
        if (!ResourceSignatureValidator.isValidResourceParam(signatureParams.get(1), HTTP_REQUEST_TYPE)) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"second parameter should be of type ballerina.http:Request");
            return;
        }
        if (nParams == 2) {
            return;
        }
    }

    private static boolean isValidResourceParam(BLangVariable param, String expectedType) {
        return expectedType.equals(param.type.toString());
    }

    public static void validateAnnotation(ResourceNode resourceNode, DiagnosticLog dlog) {
        List annotations = resourceNode.getAnnotationAttachments();
        List annVals = new ArrayList();
        int count = 0;
        for (AnnotationAttachmentNode annotation : annotations) {
            if (!annotation.getAnnotationName().getValue().equals("ResourceConfig")) continue;
            annVals = ((BLangRecordLiteral)annotation.getExpression()).keyValuePairs;
            ++count;
        }
        if (count > 1) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, resourceNode.getPosition(), (CharSequence)"There cannot be more than one resource annotations");
        } else if (count == 1) {
            for (BLangRecordLiteral.BLangRecordKeyValue keyValue : annVals) {
                if (!((BLangSimpleVarRef)keyValue.key.expr).variableName.getValue().equals("webSocketUpgrade")) continue;
                if (annVals.size() > 1) {
                    dlog.logDiagnostic(Diagnostic.Kind.ERROR, resourceNode.getPosition(), (CharSequence)"Invalid configurations for WebSocket upgrade resource");
                    continue;
                }
                if (((BLangRecordLiteral)keyValue.valueExpr).keyValuePairs.size() == 1) {
                    if (((BLangSimpleVarRef)((BLangRecordLiteral.BLangRecordKeyValue)((BLangRecordLiteral)keyValue.valueExpr).keyValuePairs.get((int)0)).key.expr).variableName.getValue().equals("upgradeService")) continue;
                    dlog.logDiagnostic(Diagnostic.Kind.ERROR, resourceNode.getPosition(), (CharSequence)"An upgradeService need to be specified for the WebSocket upgrade resource");
                    continue;
                }
                if (((BLangRecordLiteral)keyValue.valueExpr).keyValuePairs.size() != 0) continue;
                dlog.logDiagnostic(Diagnostic.Kind.ERROR, resourceNode.getPosition(), (CharSequence)"An upgradeService need to be specified for the WebSocket upgrade resource");
            }
        }
    }
}

