/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.compiler;

import java.util.List;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangResource;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;

public class WebSocketResourceValidator {
    public static void validate(String serviceName, BLangResource resource, DiagnosticLog dlog, boolean isClient) {
        switch (resource.getName().getValue()) {
            case "onOpen": 
            case "onIdleTimeout": {
                WebSocketResourceValidator.validateOnOpenResource(serviceName, resource, dlog, isClient);
                break;
            }
            case "onText": {
                WebSocketResourceValidator.validateOnTextResource(serviceName, resource, dlog, isClient);
                break;
            }
            case "onBinary": {
                WebSocketResourceValidator.validateOnBinaryResource(serviceName, resource, dlog, isClient);
                break;
            }
            case "onPing": 
            case "onPong": {
                WebSocketResourceValidator.validateOnPingPongResource(serviceName, resource, dlog, isClient);
                break;
            }
            case "onClose": {
                WebSocketResourceValidator.validateCloseResource(serviceName, resource, dlog, isClient);
                break;
            }
            default: {
                dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("Invalid resource name " + resource.getName().getValue() + " in service " + serviceName));
            }
        }
    }

    private static void validateOnOpenResource(String serviceName, BLangResource resource, DiagnosticLog dlog, boolean isClient) {
        if (!isClient || !resource.getName().getValue().equals("onOpen")) {
            List paramDetails = resource.getParameters();
            WebSocketResourceValidator.validateParamDetailsSize(paramDetails, 1, serviceName, resource, dlog);
            WebSocketResourceValidator.validateEndpointParameter(serviceName, resource, dlog, paramDetails, isClient);
        } else {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("onOpen resource is not supported for WebSocketClientService " + serviceName));
        }
    }

    private static void validateOnTextResource(String serviceName, BLangResource resource, DiagnosticLog dlog, boolean isClient) {
        List paramDetails = resource.getParameters();
        WebSocketResourceValidator.validateParamDetailsSize(paramDetails, 2, 3, serviceName, resource, dlog);
        WebSocketResourceValidator.validateEndpointParameter(serviceName, resource, dlog, paramDetails, isClient);
        if (paramDetails.size() < 2 || !"string".equals(((BLangVariable)paramDetails.get((int)1)).type.toString())) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("Invalid resource signature for " + resource.getName().getValue() + " resource in service " + serviceName + ": The second parameter should be a string"));
        }
        if (paramDetails.size() == 3 && !"boolean".equals(((BLangVariable)paramDetails.get((int)2)).type.toString())) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("Invalid resource signature for " + resource.getName().getValue() + " resource in service " + serviceName + ": The third parameter should be a boolean"));
        }
    }

    private static void validateOnBinaryResource(String serviceName, BLangResource resource, DiagnosticLog dlog, boolean isClient) {
        List paramDetails = resource.getParameters();
        WebSocketResourceValidator.validateParamDetailsSize(paramDetails, 2, 3, serviceName, resource, dlog);
        WebSocketResourceValidator.validateEndpointParameter(serviceName, resource, dlog, paramDetails, isClient);
        if (paramDetails.size() < 2 || !"blob".equals(((BLangVariable)paramDetails.get((int)1)).type.toString())) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("Invalid resource signature for " + resource.getName().getValue() + " resource in service " + serviceName + ": The second parameter should be a blob"));
        }
        if (paramDetails.size() == 3 && !"boolean".equals(((BLangVariable)paramDetails.get((int)2)).type.toString())) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("Invalid resource signature for " + resource.getName().getValue() + " resource in service " + serviceName + ": The third parameter should be a boolean"));
        }
    }

    private static void validateOnPingPongResource(String serviceName, BLangResource resource, DiagnosticLog dlog, boolean isClient) {
        List paramDetails = resource.getParameters();
        WebSocketResourceValidator.validateParamDetailsSize(paramDetails, 2, serviceName, resource, dlog);
        WebSocketResourceValidator.validateEndpointParameter(serviceName, resource, dlog, paramDetails, isClient);
        if (paramDetails.size() < 2 || !"blob".equals(((BLangVariable)paramDetails.get((int)1)).type.toString())) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("Invalid resource signature for " + resource.getName().getValue() + " resource in service " + serviceName + ": The second parameter should be a blob"));
        }
    }

    private static void validateCloseResource(String serviceName, BLangResource resource, DiagnosticLog dlog, boolean isClient) {
        List paramDetails = resource.getParameters();
        WebSocketResourceValidator.validateParamDetailsSize(paramDetails, 3, serviceName, resource, dlog);
        WebSocketResourceValidator.validateEndpointParameter(serviceName, resource, dlog, paramDetails, isClient);
        if (paramDetails.size() < 2 || !"int".equals(((BLangVariable)paramDetails.get((int)1)).type.toString())) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("Invalid resource signature for " + resource.getName().getValue() + " resource in service " + serviceName + ": The second parameter should be an int"));
        }
        if (paramDetails.size() < 3 || !"string".equals(((BLangVariable)paramDetails.get((int)2)).type.toString())) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("Invalid resource signature for " + resource.getName().getValue() + " resource in service " + serviceName + ": The third parameter should be a string"));
        }
    }

    private static void validateParamDetailsSize(List<BLangVariable> paramDetails, int expectedSize, String serviceName, BLangResource resource, DiagnosticLog dlog) {
        if (paramDetails == null || paramDetails.size() != expectedSize) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("Invalid resource signature for " + resource.getName().getValue() + " resource in service " + serviceName + ": Expected parameter count = " + expectedSize));
        }
    }

    private static void validateParamDetailsSize(List<BLangVariable> paramDetails, int min, int max, String serviceName, BLangResource resource, DiagnosticLog dlog) {
        if (paramDetails == null || paramDetails.size() < min || paramDetails.size() > max) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("Invalid resource signature for " + resource.getName().getValue() + " resource in service " + serviceName + ": Unexpected parameter count"));
        }
    }

    private static void validateEndpointParameter(String serviceName, BLangResource resource, DiagnosticLog dlog, List<BLangVariable> paramDetails, boolean isClient) {
        if (paramDetails == null || paramDetails.size() == 0 || !isClient && !"ballerina.http:WebSocketListener".equals(paramDetails.get((int)0).type.toString()) || isClient && !"ballerina.http:WebSocketClient".equals(paramDetails.get((int)0).type.toString())) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("Invalid resource signature for " + resource.getName().getValue() + " resource in service " + serviceName + ": The first parameter should be an endpoint"));
        }
    }
}

