/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.compiler;

import java.util.List;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportEndpointTypes;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.types.UserDefinedTypeNode;
import org.ballerinalang.net.http.compiler.WebSocketResourceValidator;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangService;

@SupportEndpointTypes(value={@SupportEndpointTypes.EndpointType(orgName="ballerina", packageName="http", name="WebSocketListener"), @SupportEndpointTypes.EndpointType(orgName="ballerina", packageName="http", name="WebSocketClient")})
public class WebSocketServiceCompilerPlugin
extends AbstractCompilerPlugin {
    private DiagnosticLog dlog = null;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        UserDefinedTypeNode serviceType = serviceNode.getServiceTypeStruct();
        if (serviceType != null) {
            if ("WebSocketService".equals(serviceType.getTypeName().getValue())) {
                if (annotations.size() > 1) {
                    int count = 0;
                    for (AnnotationAttachmentNode annotation : annotations) {
                        if (!annotation.getAnnotationName().getValue().equals("WebSocketServiceConfig")) continue;
                        ++count;
                    }
                    if (count > 1) {
                        this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"There cannot be more than one WebSocketService annotations");
                    }
                }
                List resources = serviceNode.getResources();
                resources.forEach(res -> WebSocketResourceValidator.validate(((BLangService)serviceNode).symbol.getName().value, res, this.dlog, false));
            } else if ("WebSocketClientService".equals(serviceType.getTypeName().getValue())) {
                if (serviceNode.getBoundEndpoints().size() > 0) {
                    this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"WebSocketClientService cannot be bound to an endpoint");
                }
                List resources = serviceNode.getResources();
                resources.forEach(res -> WebSocketResourceValidator.validate(((BLangService)serviceNode).symbol.getName().value, res, this.dlog, true));
            }
        }
    }
}

