/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.mock.nonlistening;

import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.WebSocketService;
import org.ballerinalang.net.http.WebSocketServicesRegistry;
import org.ballerinalang.net.http.serviceendpoint.Register;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="register", receiver=@Receiver(type=TypeKind.STRUCT, structType="NonListener", structPackage="ballerina.http"), args={@Argument(name="serviceType", type=TypeKind.TYPEDESC)}, isPublic=true)
public class NonListeningRegister
extends Register {
    @Override
    public void execute(Context context) {
        Service service = BLangConnectorSPIUtil.getServiceRegistered((Context)context);
        Struct serviceEndpoint = BLangConnectorSPIUtil.getConnectorEndpointStruct((Context)context);
        HTTPServicesRegistry httpServicesRegistry = this.getHttpServicesRegistry(serviceEndpoint);
        WebSocketServicesRegistry webSocketServicesRegistry = this.getWebSocketServicesRegistry(serviceEndpoint);
        if ("ballerina.http:Listener".equals(service.getEndpointName())) {
            httpServicesRegistry.registerService(service);
        }
        if ("ballerina.http:WebSocketListener".equals(service.getEndpointName())) {
            WebSocketService webSocketService = new WebSocketService(service);
            webSocketServicesRegistry.registerService(webSocketService);
        }
        context.setReturnValues(new BValue[0]);
    }
}

