/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl;

import java.util.Arrays;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.BTupleType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BLangNullReferenceException;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="parseHeader", args={@Argument(name="headerValue", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.STRING), @ReturnType(type=TypeKind.MAP, elementType=TypeKind.STRING), @ReturnType(type=TypeKind.STRUCT, structType="Error")}, isPublic=true)
public class ParseHeader
extends BlockingNativeCallableUnit {
    private static final BTupleType parseHeaderTupleType = new BTupleType(Arrays.asList(BTypes.typeString, BTypes.typeMap));

    public void execute(Context context) {
        String errMsg;
        try {
            String headerValue = context.getStringArgument(0);
            if (headerValue.contains(",")) {
                headerValue = headerValue.substring(0, headerValue.indexOf(","));
            }
            String value = headerValue.trim();
            if (headerValue.contains(";")) {
                value = HeaderUtil.getHeaderValue((String)value);
            }
            BRefValueArray contentTuple = new BRefValueArray((BType)parseHeaderTupleType);
            contentTuple.add(0L, (BRefType)new BString(value));
            contentTuple.add(1L, (BRefType)HeaderUtil.getParamMap((String)headerValue));
            context.setReturnValues(new BValue[]{contentTuple});
            return;
        }
        catch (BLangNullReferenceException ex) {
            errMsg = "failed to parse: header value cannot be null";
        }
        catch (BallerinaException ex) {
            errMsg = "failed to parse: " + ex.getMessage();
        }
        context.setReturnValues(new BValue[]{MimeUtil.getParserError((Context)context, (String)errMsg)});
    }
}

