/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl.connection;

import java.io.IOException;
import java.io.OutputStream;
import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.mime.util.MultipartDataSource;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.runtime.message.MessageDataSource;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;
import org.wso2.transport.http.netty.message.PooledDataStreamerFactory;

public abstract class ConnectionAction
implements NativeCallableUnit {
    protected void sendOutboundResponseRobust(DataContext dataContext, HTTPCarbonMessage requestMessage, BStruct outboundResponseStruct, HTTPCarbonMessage responseMessage) {
        String contentType = HttpUtil.getContentTypeFromTransportMessage(responseMessage);
        String boundaryString = null;
        if (HeaderUtil.isMultipart((String)contentType)) {
            boundaryString = HttpUtil.addBoundaryIfNotExist(responseMessage, contentType);
        }
        HttpMessageDataStreamer outboundMsgDataStreamer = this.getMessageDataStreamer(responseMessage);
        HttpResponseFuture outboundRespStatusFuture = HttpUtil.sendOutboundResponse(requestMessage, responseMessage);
        HttpResponseConnectorListener outboundResStatusConnectorListener = new HttpResponseConnectorListener(dataContext, outboundMsgDataStreamer);
        outboundRespStatusFuture.setHttpConnectorListener((HttpConnectorListener)outboundResStatusConnectorListener);
        OutputStream messageOutputStream = outboundMsgDataStreamer.getOutputStream();
        BStruct entityStruct = MimeUtil.extractEntity((BStruct)outboundResponseStruct);
        if (entityStruct != null) {
            if (boundaryString != null) {
                this.serializeMultiparts(boundaryString, entityStruct, messageOutputStream);
            } else {
                MessageDataSource outboundMessageSource = EntityBodyHandler.getMessageDataSource((BStruct)entityStruct);
                this.serializeMsgDataSource(outboundMessageSource, entityStruct, messageOutputStream);
            }
        }
    }

    private void serializeMultiparts(String boundaryString, BStruct entityStruct, OutputStream messageOutputStream) {
        BRefValueArray bodyParts = EntityBodyHandler.getBodyPartArray((BStruct)entityStruct);
        if (bodyParts != null && bodyParts.size() > 0L) {
            MultipartDataSource multipartDataSource = new MultipartDataSource(entityStruct, boundaryString);
            this.serializeMsgDataSource((MessageDataSource)multipartDataSource, entityStruct, messageOutputStream);
        } else {
            try {
                EntityBodyHandler.writeByteChannelToOutputStream((BStruct)entityStruct, (OutputStream)messageOutputStream);
            }
            catch (IOException e) {
                throw new BallerinaException("Error occurred while serializing byte channel content : " + e.getMessage());
            }
            finally {
                HttpUtil.closeMessageOutputStream(messageOutputStream);
            }
        }
    }

    protected void setResponseConnectorListener(DataContext dataContext, HttpResponseFuture outResponseStatusFuture) {
        HttpResponseConnectorListener outboundResStatusConnectorListener = new HttpResponseConnectorListener(dataContext);
        outResponseStatusFuture.setHttpConnectorListener((HttpConnectorListener)outboundResStatusConnectorListener);
    }

    protected void serializeMsgDataSource(MessageDataSource outboundMessageSource, BStruct entityStruct, OutputStream messageOutputStream) {
        try {
            if (outboundMessageSource != null) {
                outboundMessageSource.serializeData(messageOutputStream);
            } else {
                EntityBodyHandler.writeByteChannelToOutputStream((BStruct)entityStruct, (OutputStream)messageOutputStream);
            }
        }
        catch (IOException e) {
            throw new BallerinaException("Error occurred while serializing message data source : " + e.getMessage());
        }
        finally {
            HttpUtil.closeMessageOutputStream(messageOutputStream);
        }
    }

    protected HttpMessageDataStreamer getMessageDataStreamer(HTTPCarbonMessage outboundResponse) {
        PooledDataStreamerFactory pooledDataStreamerFactory = (PooledDataStreamerFactory)outboundResponse.getProperty("POOLED_BYTE_BUFFER_FACTORY");
        HttpMessageDataStreamer outboundMsgDataStreamer = pooledDataStreamerFactory != null ? pooledDataStreamerFactory.createHttpDataStreamer(outboundResponse) : new HttpMessageDataStreamer(outboundResponse);
        return outboundMsgDataStreamer;
    }

    public boolean isBlocking() {
        return false;
    }

    static class HttpResponseConnectorListener
    implements HttpConnectorListener {
        private final DataContext dataContext;
        private HttpMessageDataStreamer outboundMsgDataStreamer;

        HttpResponseConnectorListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        HttpResponseConnectorListener(DataContext dataContext, HttpMessageDataStreamer outboundMsgDataStreamer) {
            this.dataContext = dataContext;
            this.outboundMsgDataStreamer = outboundMsgDataStreamer;
        }

        public void onMessage(HTTPCarbonMessage httpCarbonMessage) {
            this.dataContext.notifyOutboundResponseStatus(null);
        }

        public void onError(Throwable throwable) {
            BStruct httpConnectorError = BLangConnectorSPIUtil.createBStruct((Context)this.dataContext.context, (String)"ballerina.http", (String)"HttpConnectorError", (Object[])new Object[0]);
            if (this.outboundMsgDataStreamer != null) {
                if (throwable instanceof IOException) {
                    this.outboundMsgDataStreamer.setIoException((IOException)throwable);
                } else {
                    this.outboundMsgDataStreamer.setIoException(new IOException(throwable.getMessage()));
                }
            }
            httpConnectorError.setStringField(0, throwable.getMessage());
            this.dataContext.notifyOutboundResponseStatus(httpConnectorError);
        }
    }
}

