/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl.connection;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Optional;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.caching.ResponseCacheControlStruct;
import org.ballerinalang.net.http.nativeimpl.connection.ConnectionAction;
import org.ballerinalang.net.http.util.CacheUtils;
import org.ballerinalang.util.observability.ObservabilityUtils;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="respond", receiver=@Receiver(type=TypeKind.STRUCT, structType="Connection", structPackage="ballerina.http"), args={@Argument(name="res", type=TypeKind.STRUCT, structType="Response", structPackage="ballerina.http")}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="HttpConnectorError", structPackage="ballerina.http")}, isPublic=true)
public class Respond
extends ConnectionAction {
    public void execute(Context context, CallableUnitCallback callback) {
        BStruct connectionStruct = (BStruct)context.getRefArgument(0);
        HTTPCarbonMessage inboundRequestMsg = HttpUtil.getCarbonMsg(connectionStruct, null);
        HttpUtil.checkFunctionValidity(connectionStruct, inboundRequestMsg);
        DataContext dataContext = new DataContext(context, callback, inboundRequestMsg);
        BStruct outboundResponseStruct = (BStruct)context.getRefArgument(1);
        HTTPCarbonMessage outboundResponseMsg = HttpUtil.getCarbonMsg(outboundResponseStruct, HttpUtil.createHttpCarbonMessage(false));
        this.setCacheControlHeader(outboundResponseStruct, outboundResponseMsg);
        HttpUtil.prepareOutboundResponse(context, inboundRequestMsg, outboundResponseMsg, outboundResponseStruct);
        if (CacheUtils.isValidCachedResponse(outboundResponseMsg, inboundRequestMsg)) {
            outboundResponseMsg.setProperty("HTTP_STATUS_CODE", (Object)HttpResponseStatus.NOT_MODIFIED.code());
            outboundResponseMsg.waitAndReleaseAllEntities();
            outboundResponseMsg.completeMessage();
        }
        Optional observerContext = ObservabilityUtils.getParentContext((Context)context);
        observerContext.ifPresent(ctx -> ctx.addTag("http.status_code", String.valueOf(outboundResponseStruct.getIntField(0))));
        this.sendOutboundResponseRobust(dataContext, inboundRequestMsg, outboundResponseStruct, outboundResponseMsg);
    }

    private void setCacheControlHeader(BStruct outboundRespStruct, HTTPCarbonMessage outboundResponse) {
        BStruct cacheControl = (BStruct)outboundRespStruct.getRefField(0);
        if (cacheControl != null && outboundResponse.getHeader(HttpHeaderNames.CACHE_CONTROL.toString()) == null) {
            ResponseCacheControlStruct respCC = new ResponseCacheControlStruct(cacheControl);
            outboundResponse.setHeader(HttpHeaderNames.CACHE_CONTROL.toString(), respCC.buildCacheControlDirectives());
        }
    }
}

